/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsWizardPage;

public class OrganizeManifestsWizard
extends RefactoringWizard {
    private OrganizeManifestsWizardPage fMainPage;

    public OrganizeManifestsWizard(PDERefactor refactoring) {
        super((Refactoring)refactoring, 2);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEUIMessages.OrganizeManifestsWizard_title);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_ORGANIZE_MANIFESTS);
    }

    public boolean performFinish() {
        this.fMainPage.performOk();
        return super.performFinish();
    }

    protected void addUserInputPages() {
        this.setDefaultPageTitle(this.getRefactoring().getName());
        Set<IProject> customProjects = this.getProjectsWithCustomBuild(((PDERefactor)this.getRefactoring()).getProcessor().getElements());
        this.fMainPage = new OrganizeManifestsWizardPage(customProjects);
        this.addPage((IWizardPage)this.fMainPage);
    }

    private Set<IProject> getProjectsWithCustomBuild(Object[] elements) {
        HashSet<IProject> result = new HashSet<IProject>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            try {
                IBuildModel buildModel;
                IPluginModelBase pluginModel;
                IProject project;
                if (element instanceof IResource && (project = ((IResource)element).getProject()) != null && project.hasNature("org.eclipse.pde.PluginNature") && (pluginModel = PDECore.getDefault().getModelManager().findModel(project)) != null && (buildModel = PluginRegistry.createBuildModel((IPluginModelBase)pluginModel)) != null && this.getCustomSelection(buildModel)) {
                    result.add(project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return result;
    }

    private boolean getCustomSelection(IBuildModel model) {
        IBuild build = model.getBuild();
        IBuildEntry customEntry = build.getEntry("custom");
        if (customEntry == null || customEntry.getTokens().length == 0) {
            return false;
        }
        return customEntry.getTokens()[0].equals("true");
    }
}

