/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.script;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.birt.report.designer.internal.ui.editors.script.IScriptMethodInfo;
import org.eclipse.birt.report.designer.internal.ui.editors.script.ScriptMethodInfo;
import org.eclipse.jface.text.Position;

public class ScriptParser {
    private final Collection<Position> commentPositions = new HashSet<Position>();
    private final Collection<Position> methodPositions = new HashSet<Position>();
    private final String script;

    public ScriptParser(String script) {
        this.script = script;
        this.parse();
    }

    protected void parse() {
        this.commentPositions.clear();
        this.methodPositions.clear();
        if (this.script != null && this.script.length() > 0) {
            boolean inComment = false;
            boolean inDoubleString = false;
            boolean inSingleString = false;
            Position commentPosition = null;
            Position methodPosition = null;
            int length = this.script.length();
            int leftMark = 0;
            int i = 0;
            block9: do {
                if (!inDoubleString && !inSingleString && !inComment && this.isCommentLine(i)) {
                    while (i < length && this.script.charAt(i++) != '\n') {
                    }
                    if (i >= length) break;
                    continue;
                }
                char ch = this.script.charAt(i++);
                switch (ch) {
                    case '/': {
                        if (inDoubleString || inSingleString || inComment || i + 1 >= length || this.script.charAt(i) != '*') continue block9;
                        inComment = true;
                        commentPosition = new Position(i++);
                        break;
                    }
                    case '*': {
                        if (inDoubleString || inSingleString || !inComment || i >= length || this.script.charAt(i) != '/' || commentPosition == null) continue block9;
                        if (this.includeMultiLine(this.script, commentPosition.getOffset(), ++i - 1)) {
                            int end = i;
                            while (end < length && this.script.charAt(end) != '\n') {
                                ++end;
                            }
                            commentPosition.setLength(end - commentPosition.getOffset() + 1);
                            this.commentPositions.add(commentPosition);
                        }
                        commentPosition = null;
                        inComment = false;
                        break;
                    }
                    case '\"': {
                        int n;
                        int j;
                        if (inComment || inSingleString) continue block9;
                        if (i - 2 >= 0) {
                            j = i - 2;
                            n = 0;
                            while (j >= 0 && this.script.charAt(j) == '\\') {
                                --j;
                                ++n;
                            }
                            if (n % 2 != 0) continue block9;
                        }
                        inDoubleString = !inDoubleString;
                        break;
                    }
                    case '\'': {
                        int n;
                        int j;
                        if (inComment || inDoubleString) continue block9;
                        if (i - 2 >= 0) {
                            j = i - 2;
                            n = 0;
                            while (j >= 0 && this.script.charAt(j) == '\\') {
                                --j;
                                ++n;
                            }
                            if (n % 2 != 0) continue block9;
                        }
                        inSingleString = !inSingleString;
                        break;
                    }
                    case 'f': {
                        if (inComment || inDoubleString || inSingleString) continue block9;
                        int begin = i - 2 >= 0 ? i - 2 : 0;
                        int end = begin + "funciton".length() + (i - 2 >= 0 ? 2 : 1);
                        Object keyword = this.script.substring(begin, Math.min(length, end));
                        Object object = keyword = i - 2 >= 0 ? keyword : " " + (String)keyword;
                        if (end > this.script.length() || !((String)keyword).matches("\\Wfunction\\W")) continue block9;
                        int start = i;
                        while (start > 0 && this.script.charAt(start - 1) != '\n') {
                            --start;
                        }
                        methodPosition = new Position(start);
                        leftMark = 0;
                        i += "funciton".length();
                        break;
                    }
                    case '{': {
                        if (inComment || inDoubleString || inSingleString || methodPosition == null) continue block9;
                        ++leftMark;
                        break;
                    }
                    case '}': {
                        int j;
                        if (inComment || inDoubleString || inSingleString || methodPosition == null || --leftMark > 0) continue block9;
                        if (this.includeMultiLine(this.script, methodPosition.getOffset(), i)) {
                            j = i;
                            while (j < length && this.script.charAt(j) != '\n') {
                                ++j;
                            }
                            methodPosition.setLength(j - methodPosition.getOffset() + (j < length ? 1 : 0));
                            this.methodPositions.add(methodPosition);
                        }
                        methodPosition = null;
                        leftMark = 0;
                    }
                }
            } while (i < length);
        }
    }

    private boolean includeMultiLine(String text, int start, int end) {
        int i = start;
        while (i < Math.min(text.length(), end)) {
            if (text.charAt(i) == '\n') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCommentLine(int index) {
        int start = index;
        while (start >= 0 && this.script.charAt(start) != '\n') {
            if (start + 1 < this.script.length() && this.script.charAt(start) == '/' && this.script.charAt(start + 1) == '/') {
                return true;
            }
            --start;
        }
        return false;
    }

    public Collection<Position> getCommentPositions() {
        return Collections.unmodifiableCollection(this.commentPositions);
    }

    public Collection<Position> getMethodPositions() {
        return Collections.unmodifiableCollection(this.methodPositions);
    }

    public Collection<IScriptMethodInfo> getAllMethodInfo() {
        HashSet<ScriptMethodInfo> allMethodInfo = new HashSet<ScriptMethodInfo>();
        Collection<Position> positions = this.getMethodPositions();
        for (Position position : positions) {
            int offset = position.getOffset();
            if (offset >= this.script.length()) continue;
            String name = this.findNameAfterFunction(offset);
            if (name == null || name.length() <= 0) {
                name = this.findNameBeforeFunction(offset);
            }
            allMethodInfo.add(new ScriptMethodInfo(name, position));
        }
        return Collections.unmodifiableCollection(allMethodInfo);
    }

    private String findNameAfterFunction(int offset) {
        String method = null;
        String[] strs = (" " + this.script.substring(offset)).split("\\Wfunction\\W", 2);
        if (strs.length > 1) {
            method = strs[1].trim();
            int i = 0;
            while (i < method.length()) {
                char ch = method.charAt(i);
                if (ch != ' ' && !Character.isJavaIdentifierPart(ch)) {
                    if (ch == '(') {
                        method = method.substring(0, i).trim();
                        break;
                    }
                    method = "";
                    break;
                }
                ++i;
            }
        }
        return method;
    }

    private String findNameBeforeFunction(int offset) {
        String method = null;
        String[] strs = (" " + this.script.substring(offset)).split("\\Wfunction\\W", 2);
        if (strs == null || strs.length <= 0) {
            return null;
        }
        if ((strs = this.script.substring(0, offset + strs[0].length()).split("[:=]")) != null && strs.length > 0) {
            int i = strs.length;
            do {
                if (i > 0) continue;
                return null;
            } while ((method = strs[--i].trim()) == null || method.length() <= 0);
            if (method == null || method.length() <= 0) {
                return null;
            }
            i = method.length() - 1;
            while (i >= 0) {
                char ch = method.charAt(i);
                if (ch != ' ' && !Character.isJavaIdentifierPart(ch)) {
                    method = method.substring(i + 1).trim();
                    break;
                }
                --i;
            }
        }
        return method;
    }
}

