/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;
import org.mozilla.javascript.ScriptableObject;

public class BirtComp
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static final String WRONG_ARGUMENT = "Wrong number of arguments for BirtComp function: {0}";
    private static final String ANY_OF = "anyOf";
    private static final String BETWEEN = "between";
    private static final String NOT_BETWEEN = "notBetween";
    private static final String EQUAL_TO = "equalTo";
    private static final String GREATER_THAN = "greaterThan";
    private static final String LESS_THAN = "lessThan";
    private static final String GREATER_OR_EQUAL = "greaterOrEqual";
    private static final String LESS_OR_EQUAL = "lessOrEqual";
    private static final String NOT_EQUAL = "notEqual";
    private static final String LIKE = "like";
    private static final String NOT_LIKE = "notLike";
    private static final String MATCH = "match";
    private static final String COMPARE_STRING = "compareString";
    private static final String PLUGIN_ID = "org.eclipse.birt.core";
    private static final String PACKAGE_ID = "org.eclipse.birt.core.script.function.bre";
    private IScriptFunctionExecutor executor;
    private static Collator myCollator = Collator.getInstance();
    private static Pattern s_JSReExprPattern;

    BirtComp(String functionName) throws BirtException {
        if (ANY_OF.equals(functionName)) {
            this.executor = new Function_AnyOf();
        } else if (BETWEEN.equals(functionName)) {
            this.executor = new Function_Between(true);
        } else if (NOT_BETWEEN.equals(functionName)) {
            this.executor = new Function_Between(false);
        } else if (EQUAL_TO.equals(functionName)) {
            this.executor = new Function_Compare(0);
        } else if (GREATER_THAN.equals(functionName)) {
            this.executor = new Function_Compare(2);
        } else if (LESS_THAN.equals(functionName)) {
            this.executor = new Function_Compare(3);
        } else if (GREATER_OR_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(4);
        } else if (LESS_OR_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(5);
        } else if (NOT_EQUAL.equals(functionName)) {
            this.executor = new Function_Compare(1);
        } else if (LIKE.equals(functionName)) {
            this.executor = new Function_Compare(6);
        } else if (NOT_LIKE.equals(functionName)) {
            this.executor = new Function_Compare(8);
        } else if (MATCH.equals(functionName)) {
            this.executor = new Function_Compare(7);
        } else if (COMPARE_STRING.equals(functionName)) {
            this.executor = new Function_Compare(9);
        } else {
            throw new BirtException(PACKAGE_ID, null, (Object)(Messages.getString("invalid.function.name") + "BirtComp." + functionName));
        }
    }

    private static int compare(Object obj1, Object obj2, Collator collator) throws BirtException {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            return 0;
        }
        if (BirtComp.isSameType(obj1, obj2)) {
            if (obj1 instanceof Boolean) {
                if (obj1.equals(obj2)) {
                    return 0;
                }
                Boolean bool = (Boolean)obj1;
                if (bool.booleanValue()) {
                    return 1;
                }
                return -1;
            }
            if (obj1 instanceof Comparable) {
                if (obj1 instanceof String) {
                    if (collator == null) {
                        return ((String)obj1).compareTo((String)obj2);
                    }
                    return BirtComp.compareAsString(obj1, obj2, collator);
                }
                return ((Comparable)obj1).compareTo(obj2);
            }
            return BirtComp.compareAsString(obj1, obj2, collator);
        }
        if (obj1 instanceof BigDecimal || obj2 instanceof BigDecimal) {
            BigDecimal a = DataTypeUtil.toBigDecimal((Object)obj1);
            BigDecimal b = DataTypeUtil.toBigDecimal((Object)obj2);
            return a.compareTo(b);
        }
        if (BirtComp.isNumericOrString(obj1) && BirtComp.isNumericOrString(obj2)) {
            return DataTypeUtil.toDouble((Object)obj1).compareTo(DataTypeUtil.toDouble((Object)obj2));
        }
        if (BirtComp.isTimeOrString(obj1) && BirtComp.isTimeOrString(obj2)) {
            return DataTypeUtil.toSqlTime((Object)obj1).compareTo(DataTypeUtil.toSqlTime((Object)obj2));
        }
        if (BirtComp.isSQLDateOrString(obj1) && BirtComp.isSQLDateOrString(obj2)) {
            return DataTypeUtil.toSqlDate((Object)obj1).compareTo(DataTypeUtil.toSqlDate((Object)obj2));
        }
        if (BirtComp.isDateOrString(obj1) && BirtComp.isDateOrString(obj2)) {
            return DataTypeUtil.toDate((Object)obj1).compareTo(DataTypeUtil.toDate((Object)obj2));
        }
        String object1 = null;
        String object2 = null;
        object1 = obj1 instanceof ScriptableObject ? DataTypeUtil.toString((Object)((ScriptableObject)obj1).getDefaultValue(null)) : DataTypeUtil.toString((Object)obj1);
        object2 = obj2 instanceof ScriptableObject ? DataTypeUtil.toString((Object)((ScriptableObject)obj2).getDefaultValue(null)) : DataTypeUtil.toString((Object)obj2);
        return BirtComp.compare(object1, object2, collator);
    }

    private static int compareAsString(Object obj1, Object obj2, Collator comp) throws BirtException {
        return comp == null ? DataTypeUtil.toString((Object)obj1).compareTo(DataTypeUtil.toString((Object)obj2)) : comp.compare(DataTypeUtil.toString((Object)obj1), DataTypeUtil.toString((Object)obj2));
    }

    private static int compareString(Object obj1, Object obj2, boolean ignoreCase, boolean trimed) throws BirtException {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        if (!(obj1 instanceof String) || !(obj2 instanceof String)) {
            throw new IllegalArgumentException();
        }
        String str1 = DataTypeUtil.toString((Object)obj1);
        String str2 = DataTypeUtil.toString((Object)obj2);
        if (ignoreCase) {
            if (trimed) {
                return str1.trim().compareToIgnoreCase(str2.trim());
            }
            return str1.compareToIgnoreCase(str2);
        }
        if (trimed) {
            return str1.trim().compareTo(str2.trim());
        }
        return str1.compareTo(str2);
    }

    private static boolean isTimeOrString(Object result) {
        return result instanceof Time || result instanceof String;
    }

    private static Matcher getJSReExprPatternMatcher(String patternStr) {
        if (s_JSReExprPattern == null) {
            s_JSReExprPattern = Pattern.compile("^/(.*)/([a-zA-Z]*)$");
        }
        return s_JSReExprPattern.matcher(patternStr);
    }

    private static boolean match(Object obj1, Object obj2) throws BirtException {
        if (obj2 == null || obj1 == null) {
            return false;
        }
        String sourceStr = obj1.toString();
        String pattern = obj2.toString();
        Matcher jsReExprMatcher = BirtComp.getJSReExprPatternMatcher(pattern);
        int flags = 0;
        if (jsReExprMatcher.matches()) {
            String flagStr = pattern.substring(jsReExprMatcher.start(2), jsReExprMatcher.end(2));
            int i = 0;
            while (i < flagStr.length()) {
                switch (flagStr.charAt(i)) {
                    case 'm': {
                        flags |= 8;
                        break;
                    }
                    case 'i': {
                        flags |= 2;
                        break;
                    }
                    case 'g': {
                        break;
                    }
                    default: {
                        throw new BirtException(PLUGIN_ID, "birt.core.BirtComp.invalidRegularExpression", (Object)pattern);
                    }
                }
                ++i;
            }
            pattern = pattern.substring(jsReExprMatcher.start(1), jsReExprMatcher.end(1));
        }
        try {
            Matcher m = Pattern.compile(pattern, flags).matcher(sourceStr);
            return m.find();
        }
        catch (PatternSyntaxException e) {
            throw new BirtException(PLUGIN_ID, "birt.core.BirtComp.invalidRegularExpression", (Object)e);
        }
    }

    private static boolean like(Object source, Object pattern, boolean ignorecase) throws BirtException {
        String sourceStr = source == null ? "" : DataTypeUtil.toLocaleNeutralString((Object)source);
        String patternStr = pattern == null ? "" : DataTypeUtil.toLocaleNeutralString((Object)pattern);
        String reservedChars = "([{^$|)?*+.";
        int patternLen = patternStr.length();
        StringBuilder buffer = new StringBuilder(patternLen * 2);
        int i = 0;
        while (i < patternLen) {
            char c = patternStr.charAt(i);
            if (c == '\\') {
                if (++i < patternLen) {
                    c = patternStr.charAt(i);
                    if (c == '%' || c == '_') {
                        buffer.append(c);
                    } else if (c == '\\') {
                        buffer.append("\\\\");
                    }
                } else {
                    buffer.append("\\\\");
                }
            } else if (c == '%') {
                buffer.append(".*");
            } else if (c == '_') {
                buffer.append(".");
            } else {
                if ("([{^$|)?*+.".indexOf(c) >= 0) {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            ++i;
        }
        try {
            String newPatternStr = buffer.toString();
            Pattern p = null;
            p = !ignorecase ? Pattern.compile(newPatternStr, 32) : Pattern.compile(newPatternStr, 34);
            Matcher m = p.matcher(sourceStr.toString());
            return m.matches();
        }
        catch (PatternSyntaxException e) {
            throw new BirtException(e.getMessage());
        }
    }

    private static boolean isSameType(Object resultExpr, Object resultOp1) {
        return resultExpr.getClass().equals(resultOp1.getClass());
    }

    private static boolean isNumericOrString(Object result) {
        return result instanceof Number || result instanceof String;
    }

    private static boolean isDateOrString(Object result) {
        return result instanceof java.util.Date || result instanceof String;
    }

    private static boolean isSQLDateOrString(Object result) {
        return result instanceof Date || result instanceof String;
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        return this.executor.execute(arguments, context);
    }

    private static class Function_AnyOf
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;

        private Function_AnyOf() {
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            Collator collator = (Collator)context.findProperty("compare_locale");
            if (args == null || args.length < 2) {
                throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, BirtComp.ANY_OF));
            }
            int i = 1;
            while (i < args.length) {
                try {
                    if (BirtComp.compare(args[0], args[i], collator) == 0) {
                        return Boolean.TRUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (args.length == 2 && args[1] instanceof Object[]) {
                Object[] objs = (Object[])args[1];
                int i2 = 0;
                while (i2 < objs.length) {
                    try {
                        if (BirtComp.compare(args[0], objs[i2], collator) == 0) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
            return Boolean.FALSE;
        }
    }

    private static class Function_Between
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        private boolean mode;

        Function_Between(boolean mode) {
            this.mode = mode;
        }

        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            Collator collator = (Collator)context.findProperty("compare_locale");
            if (args == null || args.length != 3) {
                throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, BirtComp.BETWEEN));
            }
            try {
                return this.mode ? Boolean.valueOf(BirtComp.compare(args[0], args[1], collator) >= 0 && BirtComp.compare(args[0], args[2], collator) <= 0) : Boolean.valueOf(BirtComp.compare(args[0], args[1], collator) < 0 || BirtComp.compare(args[0], args[2], collator) > 0);
            }
            catch (BirtException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
    }

    private static class Function_Compare
    implements IScriptFunctionExecutor {
        private static final long serialVersionUID = 1L;
        public static final int MODE_EQUAL = 0;
        public static final int MODE_NOT_EQUAL = 1;
        public static final int MODE_GREATERTHAN = 2;
        public static final int MODE_LESSTHAN = 3;
        public static final int MODE_GREATEROREQUAL = 4;
        public static final int MODE_LESSOREQUAL = 5;
        public static final int MODE_LIKE = 6;
        public static final int MODE_MATCH = 7;
        public static final int MODE_NOT_LIKE = 8;
        public static final int MODE_COMPARE_STRING = 9;
        private int mode;

        Function_Compare(int mode) {
            this.mode = mode;
        }

        private void throwException() {
            String func = null;
            switch (this.mode) {
                case 0: {
                    func = BirtComp.EQUAL_TO;
                    break;
                }
                case 1: {
                    func = BirtComp.NOT_EQUAL;
                    break;
                }
                case 2: {
                    func = BirtComp.GREATER_THAN;
                    break;
                }
                case 3: {
                    func = BirtComp.LESS_THAN;
                    break;
                }
                case 4: {
                    func = BirtComp.GREATER_OR_EQUAL;
                    break;
                }
                case 5: {
                    func = BirtComp.LESS_OR_EQUAL;
                    break;
                }
                case 6: {
                    func = BirtComp.LIKE;
                    break;
                }
                case 7: {
                    func = BirtComp.MATCH;
                    break;
                }
                case 8: {
                    func = BirtComp.NOT_LIKE;
                    break;
                }
                case 9: {
                    func = BirtComp.COMPARE_STRING;
                    break;
                }
                default: {
                    func = "Unknown";
                }
            }
            throw new IllegalArgumentException(MessageFormat.format(BirtComp.WRONG_ARGUMENT, func));
        }

        /*
         * Exception decompiling
         */
        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

