/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.cursor.DrilledAggregateResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.DrillOnDimensionHierarchy;

public class DrillOperationExecutor {
    public IAggregationResultSet[] execute(IAggregationResultSet[] aggregationRsFromCube, IAggregationResultSet[] aggregationRsForDrill, ICubeQueryDefinition iCubeQueryDefinition) throws IOException, DataException {
        IAggregationResultSet rs;
        IEdgeDefinition columnEdge = iCubeQueryDefinition.getEdge(2);
        IEdgeDefinition rowEdge = iCubeQueryDefinition.getEdge(1);
        List<DrillOnDimensionHierarchy> columnDrill = CubeQueryDefinitionUtil.flatternDrillFilter(columnEdge);
        List<DrillOnDimensionHierarchy> rowDrill = CubeQueryDefinitionUtil.flatternDrillFilter(rowEdge);
        ArrayList<DrillOnDimensionHierarchy> combinedDrill = new ArrayList<DrillOnDimensionHierarchy>(rowDrill);
        combinedDrill.addAll(columnDrill);
        int index = 0;
        if (columnEdge != null) {
            if (!columnEdge.getDrillFilter().isEmpty()) {
                aggregationRsFromCube[index] = rs = this.populateResultSet(aggregationRsFromCube[index], columnDrill);
            }
            ++index;
        }
        if (rowEdge != null) {
            if (!rowEdge.getDrillFilter().isEmpty()) {
                aggregationRsFromCube[index] = rs = this.populateResultSet(aggregationRsFromCube[index], rowDrill);
            }
            ++index;
        }
        if (!combinedDrill.isEmpty()) {
            int i = index;
            while (i < aggregationRsFromCube.length) {
                IAggregationResultSet rs2;
                ArrayList<IAggregationResultSet> drillRs = new ArrayList<IAggregationResultSet>();
                int j = 0;
                while (j < aggregationRsForDrill.length) {
                    if (aggregationRsForDrill[j].getAggregationDefinition().getDrilledInfo() != null && aggregationRsForDrill[j].getAggregationDefinition().getDrilledInfo().usedByAggregation(aggregationRsFromCube[i].getAggregationDefinition())) {
                        drillRs.add(aggregationRsForDrill[j]);
                    }
                    ++j;
                }
                IAggregationResultSet[] drilledAggregationResult = new IAggregationResultSet[drillRs.size()];
                int k = 0;
                while (k < drillRs.size()) {
                    drilledAggregationResult[k] = (IAggregationResultSet)drillRs.get(k);
                    ++k;
                }
                aggregationRsFromCube[i] = rs2 = this.populateResultSet(aggregationRsFromCube[i], drilledAggregationResult, combinedDrill);
                ++i;
            }
        }
        return aggregationRsFromCube;
    }

    private IAggregationResultSet populateResultSet(IAggregationResultSet aggregationRsFromCube, IAggregationResultSet[] aggregationRsFromDrill, List<DrillOnDimensionHierarchy> drillFilters) throws IOException, DataException {
        if (aggregationRsFromCube.getAllLevels() == null || aggregationRsFromCube.getAllLevels().length == 0 || aggregationRsFromCube.length() == 0) {
            return aggregationRsFromCube;
        }
        DrilledAggregateResultSet rs = new DrilledAggregateResultSet(aggregationRsFromCube, aggregationRsFromDrill, drillFilters);
        return rs;
    }

    private IAggregationResultSet populateResultSet(IAggregationResultSet aggregationRsFromCube, List<DrillOnDimensionHierarchy> drillFilters) throws IOException, DataException {
        return this.populateResultSet(aggregationRsFromCube, null, drillFilters);
    }
}

