/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.BorderInfomation;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.BorderDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IToggleDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.graphics.RGB;

public class BorderToggleDescriptorProvider
extends BorderDescriptorProvider
implements IToggleDescriptorProvider {
    private String property;

    public String getPosition() {
        if (this.property.equals("borderLeftStyle")) {
            return "left";
        }
        if (this.property.equals("borderRightStyle")) {
            return "right";
        }
        if (this.property.equals("borderTopStyle")) {
            return "top";
        }
        if (this.property.equals("borderBottomStyle")) {
            return "bottom";
        }
        if (this.property.equals("diagonalStyle")) {
            return "diagonal";
        }
        if (this.property.equals("antidiagonalStyle")) {
            return "antidiagonal";
        }
        return null;
    }

    public BorderToggleDescriptorProvider(String property) {
        this.property = property;
    }

    @Override
    public String getImageName() {
        if (this.property.equals("borderLeftStyle")) {
            return "BORDER_LEFT";
        }
        if (this.property.equals("borderRightStyle")) {
            return "BORDER_RIGHT";
        }
        if (this.property.equals("borderTopStyle")) {
            return "BORDER_TOP";
        }
        if (this.property.equals("borderBottomStyle")) {
            return "BORDER_BOTTOM";
        }
        if (this.property.equals("diagonalStyle")) {
            return "BORDER_DIAGONAL";
        }
        if (this.property.equals("antidiagonalStyle")) {
            return "BORDER_ANTIDIAGONAL";
        }
        return "";
    }

    public String getToogleValue() {
        return null;
    }

    @Override
    public String getTooltipText() {
        if (this.property.equals("borderLeftStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Left");
        }
        if (this.property.equals("borderRightStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Right");
        }
        if (this.property.equals("borderTopStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Top");
        }
        if (this.property.equals("borderBottomStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Bottom");
        }
        if (this.property.equals("diagonalStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Diagonal");
        }
        if (this.property.equals("antidiagonalStyle")) {
            return Messages.getString((String)"BordersPage.Tooltip.Antidiagonal");
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    private RGB convertToRGB(String color) {
        int[] rgbValues = ColorUtil.getRGBs((String)color);
        if (rgbValues == null) {
            return null;
        }
        return new RGB(rgbValues[0], rgbValues[1], rgbValues[2]);
    }

    @Override
    public Object load() {
        BorderInfomation info = new BorderInfomation();
        if (this.property.equals("borderLeftStyle")) {
            info.setPosition("left");
            info.setStyle(this.getLocalStringValue("borderLeftStyle"));
            info.setWidth(this.getLocalStringValue("borderLeftWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderLeftColor")));
            info.setDefaultStyle(this.getDefaultStringValue("borderLeftStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("borderLeftWidth"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("borderLeftColor")));
            info.setInheritedStyle(this.getDisplayValue("borderLeftStyle"));
            info.setInheritedWidth(this.getDisplayValue("borderLeftWidth"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("borderLeftColor")));
        } else if (this.property.equals("borderRightStyle")) {
            info.setPosition("right");
            info.setStyle(this.getLocalStringValue("borderRightStyle"));
            info.setWidth(this.getLocalStringValue("borderRightWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderRightColor")));
            info.setDefaultStyle(this.getDefaultStringValue("borderRightStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("borderRightWidth"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("borderRightColor")));
            info.setInheritedStyle(this.getDisplayValue("borderRightStyle"));
            info.setInheritedWidth(this.getDisplayValue("borderRightWidth"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("borderRightColor")));
        } else if (this.property.equals("borderTopStyle")) {
            info.setPosition("top");
            info.setStyle(this.getLocalStringValue("borderTopStyle"));
            info.setWidth(this.getLocalStringValue("borderTopWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderTopColor")));
            info.setDefaultStyle(this.getDefaultStringValue("borderTopStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("borderTopWidth"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("borderTopColor")));
            info.setInheritedStyle(this.getDisplayValue("borderTopStyle"));
            info.setInheritedWidth(this.getDisplayValue("borderTopWidth"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("borderTopColor")));
        } else if (this.property.equals("borderBottomStyle")) {
            info.setPosition("bottom");
            info.setStyle(this.getLocalStringValue("borderBottomStyle"));
            info.setWidth(this.getLocalStringValue("borderBottomWidth"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("borderBottomColor")));
            info.setDefaultStyle(this.getDefaultStringValue("borderBottomStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("borderBottomWidth"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("borderBottomColor")));
            info.setInheritedStyle(this.getDisplayValue("borderBottomStyle"));
            info.setInheritedWidth(this.getDisplayValue("borderBottomWidth"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("borderBottomColor")));
        } else if (this.property.equals("diagonalStyle")) {
            info.setPosition("diagonal");
            info.setStyle(this.getLocalStringValue("diagonalStyle"));
            info.setWidth(this.getLocalStringValue("diagonalThickness"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("diagonalColor")));
            info.setDefaultStyle(this.getDefaultStringValue("diagonalStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("diagonalThickness"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("diagonalColor")));
            info.setInheritedStyle(this.getDisplayValue("diagonalStyle"));
            info.setInheritedWidth(this.getDisplayValue("diagonalThickness"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("diagonalColor")));
        } else if (this.property.equals("antidiagonalStyle")) {
            info.setPosition("antidiagonal");
            info.setStyle(this.getLocalStringValue("antidiagonalStyle"));
            info.setWidth(this.getLocalStringValue("antidiagonalThickness"));
            info.setColor(this.convertToRGB(this.getLocalStringValue("antidiagonalColor")));
            info.setDefaultStyle(this.getDefaultStringValue("antidiagonalStyle"));
            info.setDefaultWidth(this.getDefaultStringValue("antidiagonalThickness"));
            info.setDefaultColor(this.convertToRGB(this.getDefaultStringValue("antidiagonalColor")));
            info.setInheritedStyle(this.getDisplayValue("antidiagonalStyle"));
            info.setInheritedWidth(this.getDisplayValue("antidiagonalThickness"));
            info.setInheritedColor(this.convertToRGB(this.getDisplayValue("antidiagonalColor")));
        }
        return info;
    }

    @Override
    public void save(Object value) throws SemanticException {
        String color;
        BorderInfomation info = (BorderInfomation)value;
        RGB rgb = info.getOriginColor();
        int colorValue = -1;
        if (rgb != null) {
            colorValue = ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue);
            color = ColorUtil.format((int)colorValue, (int)0);
        } else {
            color = null;
        }
        if (info.getPosition().equals("top")) {
            this.save("borderTopStyle", info.getOriginStyle());
            this.save("borderTopColor", color);
            this.save("borderTopWidth", info.getOriginWidth());
        } else if (info.getPosition().equals("bottom")) {
            this.save("borderBottomStyle", info.getOriginStyle());
            this.save("borderBottomColor", color);
            this.save("borderBottomWidth", info.getOriginWidth());
        } else if (info.getPosition().equals("left")) {
            this.save("borderLeftStyle", info.getOriginStyle());
            this.save("borderLeftColor", color);
            this.save("borderLeftWidth", info.getOriginWidth());
        } else if (info.getPosition().equals("right")) {
            this.save("borderRightStyle", info.getOriginStyle());
            this.save("borderRightColor", color);
            this.save("borderRightWidth", info.getOriginWidth());
        } else if (info.getPosition().equals("diagonal")) {
            this.save("diagonalStyle", info.getOriginStyle());
            this.save("diagonalColor", color);
            this.save("diagonalThickness", info.getOriginWidth());
        } else if (info.getPosition().equals("antidiagonal")) {
            this.save("antidiagonalStyle", info.getOriginStyle());
            this.save("antidiagonalColor", color);
            this.save("antidiagonalThickness", info.getOriginWidth());
        }
    }

    @Override
    void handleModifyEvent() {
    }

    @Override
    public void reset() throws SemanticException {
        if (this.getPosition().equals("top")) {
            this.save("borderTopStyle", null);
            this.save("borderTopColor", null);
            this.save("borderTopWidth", null);
        } else if (this.getPosition().equals("bottom")) {
            this.save("borderBottomStyle", null);
            this.save("borderBottomColor", null);
            this.save("borderBottomWidth", null);
        } else if (this.getPosition().equals("left")) {
            this.save("borderLeftStyle", null);
            this.save("borderLeftColor", null);
            this.save("borderLeftWidth", null);
        } else if (this.getPosition().equals("right")) {
            this.save("borderRightStyle", null);
            this.save("borderRightColor", null);
            this.save("borderRightWidth", null);
        } else if (this.getPosition().equals("diagonal")) {
            this.save("diagonalStyle", null);
            this.save("diagonalColor", null);
            this.save("diagonalThickness", null);
        } else if (this.getPosition().equals("antidiagonal")) {
            this.save("antidiagonalStyle", null);
            this.save("antidiagonalColor", null);
            this.save("antidiagonalThickness", null);
        }
    }

    public String getProperty() {
        return this.property;
    }
}

