/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.VirtualField;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        int pos;
        HierarchyHandle hierarchy;
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        if (parentElement instanceof DataSetHandle) {
            Object[] children = OlapUtil.getDataFields((DataSetHandle)parentElement);
            Arrays.sort(children, new CustomComparator());
            return children;
        }
        if (parentElement instanceof TabularCubeHandle) {
            ArrayList<Object> list = new ArrayList<Object>();
            DataSetHandle primary = ((TabularCubeHandle)parentElement).getDataSet();
            list.add(primary);
            Object adapter = ElementAdapterManager.getAdapter((Object)((TabularCubeHandle)parentElement).getModuleHandle(), List.class);
            if (adapter instanceof List && ((List)adapter).size() > 0) {
                VirtualField sharedDimensions = new VirtualField("shared dimensions");
                sharedDimensions.setModel(adapter);
                list.add(sharedDimensions);
            }
            if (OlapUtil.getAvailableDatasets().length > 1) {
                VirtualField other = new VirtualField("other");
                other.setModel(parentElement);
                list.add(other);
            }
            return list.toArray();
        }
        if (parentElement instanceof VirtualField && ((VirtualField)parentElement).getType().equals("other")) {
            ArrayList<DataSetHandle> datasets = new ArrayList<DataSetHandle>(Arrays.asList(OlapUtil.getAvailableDatasets()));
            datasets.remove(((TabularCubeHandle)((VirtualField)parentElement).getModel()).getDataSet());
            return datasets.toArray();
        }
        if (parentElement instanceof VirtualField && ((VirtualField)parentElement).getType().equals("shared dimensions")) {
            return ((List)((VirtualField)parentElement).getModel()).toArray();
        }
        if (parentElement instanceof DimensionHandle && (hierarchy = (HierarchyHandle)((DimensionHandle)parentElement).getContent("hierarchies", 0)).getLevelCount() > 0) {
            return new Object[]{hierarchy.getLevel(0)};
        }
        if (parentElement instanceof LevelHandle && (hierarchy = (HierarchyHandle)((LevelHandle)parentElement).getContainer()).getLevel((pos = ((LevelHandle)parentElement).getIndex()) + 1) != null) {
            return new Object[]{hierarchy.getLevel(pos + 1)};
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        HierarchyHandle hierarchy;
        if (element instanceof Object[]) {
            return ((Object[])element).length > 0;
        }
        if (element instanceof DataSetHandle) {
            return OlapUtil.getDataFields((DataSetHandle)element).length > 0;
        }
        if (element instanceof TabularCubeHandle && ((TabularCubeHandle)element).getDataSet() != null) {
            return true;
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("other") && OlapUtil.getAvailableDatasets().length > 1) {
            return true;
        }
        if (element instanceof VirtualField && ((VirtualField)element).getType().equals("shared dimensions")) {
            return true;
        }
        if (element instanceof DimensionHandle && (hierarchy = (HierarchyHandle)((DimensionHandle)element).getContent("hierarchies", 0)).getLevelCount() > 0) {
            return true;
        }
        if (element instanceof LevelHandle) {
            int pos;
            hierarchy = (HierarchyHandle)((LevelHandle)element).getContainer();
            return hierarchy.getLevel((pos = ((LevelHandle)element).getIndex()) + 1) != null;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    static class CustomComparator
    implements Comparator {
        CustomComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String name1 = OlapUtil.getDataFieldDisplayName((ResultSetColumnHandle)arg0);
            String name2 = OlapUtil.getDataFieldDisplayName((ResultSetColumnHandle)arg1);
            if (name1 == null) {
                return -1;
            }
            return name1.compareTo(name2);
        }
    }
}

