/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.widget;

import org.eclipse.birt.report.designer.ui.widget.CSashForm;
import org.eclipse.birt.report.designer.ui.widget.CSashFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class CSashFormLayout
extends Layout {
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        CSashForm sashForm = (CSashForm)composite;
        Control[] cArray = sashForm.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        boolean vertical = sashForm.getOrientation() == 512;
        int maxIndex = 0;
        int maxValue = 0;
        int i = 0;
        while (i < cArray.length) {
            Point size;
            if (vertical) {
                size = cArray[i].computeSize(wHint, -1, flushCache);
                if (size.y > maxValue) {
                    maxIndex = i;
                    maxValue = size.y;
                }
                width = Math.max(width, size.x);
            } else {
                size = cArray[i].computeSize(-1, hHint, flushCache);
                if (size.x > maxValue) {
                    maxIndex = i;
                    maxValue = size.x;
                }
                height = Math.max(height, size.y);
            }
            ++i;
        }
        long[] ratios = new long[cArray.length];
        long total = 0L;
        int obligatedWidth = 0;
        int i2 = 0;
        while (i2 < cArray.length) {
            Object data = cArray[i2].getLayoutData();
            if (data instanceof CSashFormData) {
                ratios[i2] = ((CSashFormData)data).weight;
            } else {
                data = new CSashFormData();
                cArray[i2].setLayoutData(data);
                ratios[i2] = 13108L;
                ((CSashFormData)data).weight = 13108L;
            }
            if (ratios[i2] != -1L) {
                total += ratios[i2];
            } else {
                obligatedWidth += ((CSashFormData)data).exactWidth;
            }
            ++i2;
        }
        if (ratios[maxIndex] > 0L) {
            int sashwidth;
            int n = sashwidth = sashForm.sashes.length > 0 ? sashForm.SASH_WIDTH + sashForm.sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
            if (vertical) {
                height += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth + obligatedWidth;
            } else {
                width += (int)(total * (long)maxValue / ratios[maxIndex]) + (cArray.length - 1) * sashwidth + obligatedWidth;
            }
        }
        width += sashForm.getBorderWidth() * 2;
        height += sashForm.getBorderWidth() * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int sashwidth;
        int i;
        Sash[] newSashes;
        CSashForm sashForm = (CSashForm)composite;
        Rectangle area = sashForm.getClientArea();
        if (area.width <= 1 || area.height <= 1) {
            return;
        }
        Control[] newControls = sashForm.getControls(true);
        if (sashForm.controls.length == 0 && newControls.length == 0) {
            return;
        }
        Control[] controls = sashForm.controls = newControls;
        if (sashForm.maxControl != null && !sashForm.maxControl.isDisposed()) {
            int i2 = 0;
            while (i2 < controls.length) {
                if (controls[i2] != sashForm.maxControl) {
                    controls[i2].setBounds(-200, -200, 0, 0);
                } else {
                    controls[i2].setBounds(area);
                }
                ++i2;
            }
            return;
        }
        if (sashForm.sashes.length < controls.length - 1) {
            newSashes = new Sash[controls.length - 1];
            System.arraycopy(sashForm.sashes, 0, newSashes, 0, sashForm.sashes.length);
            i = sashForm.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash((Composite)sashForm, sashForm.sashStyle);
                newSashes[i].setBackground(sashForm.background);
                newSashes[i].setForeground(sashForm.foreground);
                newSashes[i].addListener(13, sashForm.sashListener);
                ++i;
            }
            sashForm.sashes = newSashes;
        }
        if (sashForm.sashes.length > controls.length - 1) {
            if (controls.length == 0) {
                int i3 = 0;
                while (i3 < sashForm.sashes.length) {
                    sashForm.sashes[i3].dispose();
                    ++i3;
                }
                sashForm.sashes = new Sash[0];
            } else {
                newSashes = new Sash[controls.length - 1];
                System.arraycopy(sashForm.sashes, 0, newSashes, 0, newSashes.length);
                i = controls.length - 1;
                while (i < sashForm.sashes.length) {
                    sashForm.sashes[i].dispose();
                    ++i;
                }
                sashForm.sashes = newSashes;
            }
        }
        if (controls.length == 0) {
            return;
        }
        Sash[] sashes = sashForm.sashes;
        long[] ratios = new long[controls.length];
        long total = 0L;
        int obligatedWidth = 0;
        int i4 = 0;
        while (i4 < controls.length) {
            Object data = controls[i4].getLayoutData();
            if (data instanceof CSashFormData) {
                ratios[i4] = ((CSashFormData)data).weight;
            } else {
                data = new CSashFormData();
                controls[i4].setLayoutData(data);
                ratios[i4] = 13108L;
                ((CSashFormData)data).weight = 13108L;
            }
            if (ratios[i4] != -1L) {
                total += ratios[i4];
            } else {
                obligatedWidth += ((CSashFormData)data).exactWidth;
            }
            ++i4;
        }
        int n = sashwidth = sashes.length > 0 ? sashForm.SASH_WIDTH + sashes[0].getBorderWidth() * 2 : sashForm.SASH_WIDTH;
        if (sashForm.getOrientation() == 256) {
            int remainWidth = area.width - obligatedWidth;
            int width = 0;
            if (ratios[0] != -1L) {
                width = (int)(ratios[0] * (long)(remainWidth - sashes.length * sashwidth) / total);
            } else {
                CSashFormData cData = (CSashFormData)controls[0].getLayoutData();
                width = cData.exactWidth;
            }
            int x = area.x;
            controls[0].setBounds(x, area.y, width, area.height);
            x += width;
            int i5 = 1;
            while (i5 < controls.length - 1) {
                sashes[i5 - 1].setBounds(x, area.y, sashwidth, area.height);
                x += sashwidth;
                if (ratios[i5] != -1L) {
                    width = (int)(ratios[i5] * (long)(remainWidth - sashes.length * sashwidth) / total);
                } else {
                    CSashFormData cData = (CSashFormData)controls[i5].getLayoutData();
                    width = cData.exactWidth;
                }
                controls[i5].setBounds(x, area.y, width, area.height);
                x += width;
                ++i5;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(x, area.y, sashwidth, area.height);
                width = area.width - (x += sashwidth);
                controls[controls.length - 1].setBounds(x, area.y, width, area.height);
            }
        } else {
            int remainHeight = area.height - obligatedWidth;
            int height = 0;
            if (ratios[0] != -1L) {
                height = (int)(ratios[0] * (long)(remainHeight - sashes.length * sashwidth) / total);
            } else {
                CSashFormData cData = (CSashFormData)controls[0].getLayoutData();
                height = cData.exactWidth;
            }
            int y = area.y;
            controls[0].setBounds(area.x, y, area.width, height);
            y += height;
            int i6 = 1;
            while (i6 < controls.length - 1) {
                sashes[i6 - 1].setBounds(area.x, y, area.width, sashwidth);
                y += sashwidth;
                if (ratios[i6] != -1L) {
                    height = (int)(ratios[i6] * (long)(remainHeight - sashes.length * sashwidth) / total);
                } else {
                    CSashFormData cData = (CSashFormData)controls[i6].getLayoutData();
                    height = cData.exactWidth;
                }
                controls[i6].setBounds(area.x, y, area.width, height);
                y += height;
                ++i6;
            }
            if (controls.length > 1) {
                sashes[sashes.length - 1].setBounds(area.x, y, area.width, sashwidth);
                height = area.height - (y += sashwidth);
                controls[controls.length - 1].setBounds(area.x, y, area.width, height);
            }
        }
    }
}

