/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.eclipse.birt.data.oda.pojo.impl.internal.ClassMethodFieldBuffer;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FieldSource
implements IMappingSource {
    private String name;

    public FieldSource(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object fetchValue(Object from, ClassLoader pojoClassLoader, ClassMethodFieldBuffer cmfbInstance) throws OdaException {
        if (from == null || cmfbInstance == null) {
            return null;
        }
        Field f = cmfbInstance.getField(from.getClass(), this.getName());
        try {
            return f.get(from);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new OdaException((Throwable)e);
        }
    }

    @Override
    public Element createElement(Document doc) {
        Element ele = doc.createElement("Field");
        ele.setAttribute("name", this.getName());
        return ele;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSource other = (FieldSource)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public void prepareParameterValues(Map<String, Object> paramValues, ClassLoader pojoClassLoader) throws OdaException {
    }
}

