/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class Section {
    protected static final int HORIZONTAL_GAP = 8;
    private String labelText;
    protected Label displayLabel;
    protected boolean isFormStyle;
    private int layoutNum = -1;
    protected Composite parent;
    protected int placeholder = 0;
    protected boolean holderGrabSpace = true;
    protected Label placeholderLabel;
    private boolean isReadOnly = false;

    protected Section(String labelText, Composite parent, boolean isFormStyle) {
        this.isFormStyle = isFormStyle;
        this.init(labelText);
        this.parent = parent;
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    public abstract void createSection();

    public abstract void layout();

    public abstract void load();

    public Label getLabelControl() {
        return this.displayLabel;
    }

    protected Label getLabelControl(Composite parent) {
        if (this.displayLabel == null) {
            this.displayLabel = FormWidgetFactory.getInstance().createLabel(parent, 16384, this.isFormStyle);
            this.displayLabel.setFont(parent.getFont());
            this.displayLabel.setLayoutData((Object)new GridData());
            String text = this.getLabelText();
            if (text != null) {
                this.displayLabel.setText(text);
            }
            this.displayLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    Section.this.displayLabel = null;
                }
            });
        } else {
            this.checkParent((Control)this.displayLabel, parent);
        }
        return this.displayLabel;
    }

    public String getLabelText() {
        return this.labelText;
    }

    protected void init(String text) {
        this.labelText = text;
    }

    public void setLabelText(String text) {
        Assert.isNotNull((Object)text);
        this.labelText = text;
        if (this.displayLabel != null) {
            this.displayLabel.setText(text);
        }
    }

    public abstract void setInput(Object var1);

    public void setGridPlaceholder(int hSpan, boolean grabSpace) {
        this.placeholder = hSpan;
        this.holderGrabSpace = grabSpace;
    }

    protected Label getGridPlaceholder(Composite parent) {
        if (this.placeholder == 0) {
            return null;
        }
        if (this.placeholderLabel == null) {
            this.placeholderLabel = FormWidgetFactory.getInstance().createLabel(parent, this.isFormStyle);
            GridData data = new GridData();
            data.horizontalSpan = this.placeholder;
            data.grabExcessHorizontalSpace = this.holderGrabSpace;
            this.placeholderLabel.setLayoutData((Object)data);
        }
        return this.placeholderLabel;
    }

    public Label getGridPlaceholder() {
        return this.placeholderLabel;
    }

    public int getLayoutNum() {
        return this.layoutNum;
    }

    public void setLayoutNum(int layoutNum) {
        this.layoutNum = layoutNum;
    }

    public abstract void setHidden(boolean var1);

    public abstract void setVisible(boolean var1);

    public void reset() {
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }
}

