/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class ResetAttributePage
extends AttributePage {
    public void reset() {
        if (!this.canReset()) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(Messages.getString((String)"ResetAttributePage.Style.Restore.Transaction.Name"));
        Section[] sectionArray = this.getSections();
        int i = 0;
        while (i < sectionArray.length) {
            Section section = sectionArray[i];
            section.reset();
            ++i;
        }
        stack.commit();
    }

    protected void resetAll() {
        if (!this.canResetAll()) {
            return;
        }
        List handles = DEUtil.getInputElements((Object)this.input);
        if (handles != null) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"ResetAttributePage.Style.Restore.All.Transaction.Name"));
            try {
                for (Object handle : handles) {
                    if (!(handle instanceof DesignElementHandle)) continue;
                    DEUtil.resetAllStyleProperties((DesignElementHandle)((DesignElementHandle)handle));
                }
                stack.commit();
            }
            catch (SemanticException e) {
                stack.rollback();
                ExceptionUtil.handle((Throwable)e);
            }
        }
    }

    protected boolean canReset() {
        return true;
    }

    protected boolean canResetAll() {
        return this.canReset();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IAction.class && this.canReset()) {
            return new Action[]{new ResetAction()};
        }
        return null;
    }

    class ResetAction
    extends Action {
        ResetAction() {
            super(null, ResetAttributePage.this.canResetAll() ? 4 : 1);
            this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"StyleRestore"));
            this.setToolTipText(Messages.getString((String)"ResetAttributePage.Style.Restore.TooltipText"));
            if (ResetAttributePage.this.canResetAll()) {
                this.setMenuCreator(new IMenuCreator(){
                    private Menu mMenu;
                    private Menu cMenu;

                    public Menu getMenu(Menu parent) {
                        if (this.mMenu != null && !this.mMenu.isDisposed()) {
                            return this.mMenu;
                        }
                        this.mMenu = new Menu(parent);
                        this.initMenu(this.mMenu);
                        return this.mMenu;
                    }

                    public Menu getMenu(Control parent) {
                        if (this.cMenu != null && !this.cMenu.isDisposed()) {
                            return this.cMenu;
                        }
                        this.cMenu = new Menu(parent);
                        this.initMenu(this.cMenu);
                        return this.cMenu;
                    }

                    private void initMenu(Menu parent) {
                        MenuItem mi = new MenuItem(parent, 8);
                        mi.setText(Messages.getString((String)"ResetAttributePage.Style.Restore.Menu.Name"));
                        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ResetAttributePage.this.reset();
                            }
                        });
                        mi = new MenuItem(parent, 8);
                        mi.setText(Messages.getString((String)"ResetAttributePage.Style.Restore.All.Menu.Name"));
                        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ResetAttributePage.this.resetAll();
                            }
                        });
                    }

                    public void dispose() {
                        if (this.mMenu != null && !this.mMenu.isDisposed()) {
                            this.mMenu.dispose();
                            this.mMenu = null;
                        }
                        if (this.cMenu != null && !this.cMenu.isDisposed()) {
                            this.cMenu.dispose();
                            this.cMenu = null;
                        }
                    }
                });
            }
        }

        public void run() {
            ResetAttributePage.this.reset();
        }
    }
}

