/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.olap.data.document.DirectoryDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.FileDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.RADocumentManager;

public class DocumentManagerFactory {
    private static final String tmpPath = PropertySecurity.getSystemProperty("java.io.tmpdir");
    private static final String DEFAULT_CUB_MANAGER_NAME = "cub1";

    static {
        File tmp = new File(tmpPath);
        if (!FileSecurity.fileExist(tmp)) {
            FileSecurity.fileMakeDirs(tmp);
        }
    }

    public static IDocumentManager createDirectoryDocumentManager(boolean deleteOldDocument) throws DataException {
        return new DirectoryDocumentManager(tmpPath, deleteOldDocument);
    }

    public static IDocumentManager createFileDocumentManager() throws DataException, IOException {
        return FileDocumentManager.createManager(tmpPath, DEFAULT_CUB_MANAGER_NAME);
    }

    public static IDocumentManager createFileDocumentManager(String tempDir) throws DataException, IOException {
        return FileDocumentManager.createManager(tempDir, DEFAULT_CUB_MANAGER_NAME);
    }

    public static IDocumentManager loadFileDocumentManager() throws DataException, IOException {
        return FileDocumentManager.loadManager(tmpPath, DEFAULT_CUB_MANAGER_NAME);
    }

    public static IDocumentManager createRADocumentManager(IDocArchiveReader reader) throws DataException, IOException {
        return new RADocumentManager(reader);
    }

    public static IDocumentManager createDirectoryDocumentManager(boolean deleteOldDocument, String dirName) throws DataException {
        return new DirectoryDocumentManager(dirName, deleteOldDocument);
    }

    public static IDocumentManager createFileDocumentManager(String dirName, String managerName) throws DataException, IOException {
        return FileDocumentManager.createManager(dirName, managerName);
    }

    public static IDocumentManager createFileDocumentManager(String dirName, String managerName, int cacheSize) throws DataException, IOException {
        return FileDocumentManager.createManager(dirName, managerName, cacheSize);
    }

    public static IDocumentManager loadFileDocumentManager(String dirName, String managerName) throws DataException, IOException {
        return FileDocumentManager.loadManager(dirName, managerName);
    }
}

