/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.document.CacheProvider;
import org.eclipse.birt.data.engine.impl.document.IRDGroupUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

abstract class BaseCachedResultSet
implements CacheProvider,
IResultIterator {
    private int currRowIndex = -1;
    protected int rowCount;
    protected IResultClass resultClass;
    protected ResultSetCache smartCache;
    protected IRDGroupUtil rdGroupUtil;

    BaseCachedResultSet() {
    }

    @Override
    public IResultClass getResultClass() throws DataException {
        return this.resultClass;
    }

    @Override
    public int getRowCount() throws DataException {
        return this.rowCount;
    }

    @Override
    public boolean next() throws DataException {
        boolean hasNext = this.smartCache.next();
        this.currRowIndex = hasNext ? ++this.currRowIndex : -1;
        if (this.rdGroupUtil != null) {
            this.rdGroupUtil.next(hasNext);
        }
        return hasNext;
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        return this.smartCache.getCurrentResult();
    }

    @Override
    public int getCurrentResultIndex() throws DataException {
        if (this.getCurrentResult() != null) {
            return this.currRowIndex;
        }
        return -1;
    }

    @Override
    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.rdGroupUtil.getCurrentGroupIndex(groupLevel);
    }

    @Override
    public int getStartingGroupLevel() throws DataException {
        return this.rdGroupUtil.getStartingGroupLevel();
    }

    @Override
    public int getEndingGroupLevel() throws DataException {
        return this.rdGroupUtil.getEndingGroupLevel();
    }

    @Override
    public void first(int groupingLevel) throws DataException {
        throw new DataException("data.engine.unsupportOperationException");
    }

    @Override
    public void last(int groupingLevel) throws DataException {
        this.rdGroupUtil.last(groupingLevel);
    }

    @Override
    public void close() throws DataException {
        this.smartCache.close();
    }

    @Override
    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.rdGroupUtil.getGroupStartAndEndIndex(groupLevel);
    }

    @Override
    public ResultSetCache getResultSetCache() {
        return this.smartCache;
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public int getCurrentIndex() {
        return this.currRowIndex;
    }

    @Override
    public void moveTo(int destIndex) throws DataException {
        assert (destIndex >= this.currRowIndex);
        int forwardSteps = destIndex - this.currRowIndex;
        int i = 0;
        while (i < forwardSteps) {
            this.next();
            ++i;
        }
    }

    @Override
    public IExecutorHelper getExecutorHelper() {
        return null;
    }

    @Override
    public Object getAggrValue(String aggrName) throws DataException {
        throw new UnsupportedOperationException();
    }
}

