/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import org.eclipse.birt.report.designer.internal.ui.views.IReportImageDecorator;
import org.eclipse.birt.report.designer.internal.ui.views.LibraryImageDescriptor;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class LibraryElementImageDecorator
implements IReportImageDecorator {
    private static int Normal_Element = 1;
    private static int Library_Element = 2;
    private static int Local_Library_Element = 4;
    private String Library_Key = "LibraryKey";
    private String Local_Library_Key = "LocalLibraryKey";

    @Override
    public Image decorateImage(Image image, Object element) {
        int flag = this.getElementFlag(element);
        if ((flag & Normal_Element) != 0) {
            return image;
        }
        String key = "";
        if (element instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)element;
            key = handle.getElement().getDefn().getName();
        } else if (element instanceof EmbeddedImageHandle) {
            EmbeddedImageHandle imageHandle = (EmbeddedImageHandle)element;
            key = imageHandle.getQualifiedName();
        }
        LibraryImageDescriptor descriptor = null;
        if ((flag & Library_Element) != 0) {
            key = String.valueOf(key) + this.Library_Key;
            descriptor = new LibraryImageDescriptor(image, ReportPlatformUIImages.getImageDescriptor("Report Library Over"));
        } else if ((flag & Local_Library_Element) != 0) {
            key = String.valueOf(key) + this.Local_Library_Key;
            descriptor = new LibraryImageDescriptor(image, ReportPlatformUIImages.getImageDescriptor("Report Local Library Over"));
        }
        ImageRegistry regiest = ReportPlugin.getDefault().getImageRegistry();
        ImageDescriptor temp = regiest.getDescriptor(key);
        if (temp != null) {
            return temp.createImage();
        }
        if (descriptor != null) {
            regiest.put(key, (ImageDescriptor)descriptor);
            return descriptor.createImage();
        }
        return image;
    }

    private int getElementFlag(Object element) {
        DesignElementHandle handle;
        if (!(element instanceof DesignElementHandle) && !(element instanceof EmbeddedImageHandle)) {
            return Normal_Element;
        }
        if (element instanceof EmbeddedImageHandle) {
            EmbeddedImageHandle image = (EmbeddedImageHandle)element;
            if (image.isLibReference()) {
                return Library_Element;
            }
        } else if (element instanceof DesignElementHandle && DEUtil.isLinkedElement((DesignElementHandle)(handle = (DesignElementHandle)element))) {
            if (handle.hasLocalProperties()) {
                return Local_Library_Element;
            }
            return Library_Element;
        }
        return Normal_Element;
    }
}

