/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IHighlightRule;
import org.eclipse.birt.report.engine.script.internal.element.HighlightRuleImpl;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class HighlightRuleMethodUtil {
    public static void addHighlightRule(DesignElementHandle handle, IHighlightRule rule) throws ScriptException {
        PropertyHandle propHandle = handle.getPropertyHandle("highlightRules");
        try {
            propHandle.addItem(rule.getStructure());
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public static IHighlightRule[] getHighlightRules(DesignElementHandle handle) {
        PropertyHandle propHandle = handle.getPropertyHandle("highlightRules");
        Iterator iterator = propHandle.iterator();
        ArrayList<HighlightRuleImpl> rList = new ArrayList<HighlightRuleImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            HighlightRuleHandle ruleHandle = (HighlightRuleHandle)iterator.next();
            HighlightRuleImpl rule = new HighlightRuleImpl(ruleHandle);
            rList.add(rule);
            ++count;
        }
        return rList.toArray(new IHighlightRule[count]);
    }

    public static void removeHighlightRule(DesignElementHandle handle, IHighlightRule rule) throws ScriptException {
        PropertyHandle propHandle = handle.getPropertyHandle("highlightRules");
        try {
            propHandle.removeItem((Object)rule.getStructure());
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public static void removeHighlightRules(DesignElementHandle handle) throws ScriptException {
        PropertyHandle propHandle = handle.getPropertyHandle("highlightRules");
        try {
            propHandle.clearValue();
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

