/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.hive;

public class HiveConstants {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.data.oda.hive";
    public static final String DRIVER_CLASS = "org.eclipse.birt.report.data.oda.hive.HiveDriver";
    @Deprecated
    public static final String DRIVER_URL = "jdbc:hive://localhost:10000/default";
    @Deprecated
    public static final String HIVE_DRIVER_CLASS = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String HIVE_ADD_FILE_PROPERTY = "addListFile";
    public static final String HS1_JDBC_DRIVER_CLASS = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String HS1_URL_PROTOCOL = "jdbc:hive:";
    private static final String DEFAULT_URL_SERVER = "//localhost:10000/default";
    public static final String HS1_DEFAULT_URL = "jdbc:hive://localhost:10000/default";
    public static final String HS2_JDBC_DRIVER_CLASS = "org.apache.hive.jdbc.HiveDriver";
    public static final String HS2_URL_PROTOCOL = "jdbc:hive2:";
    public static final String HS2_DEFAULT_URL = "jdbc:hive2://localhost:10000/default";

    public static String formatHiveServer1URL(String dbURL) {
        return HiveConstants.resetURLProtocol(dbURL, HS1_URL_PROTOCOL);
    }

    public static String formatHiveServer2URL(String dbURL) {
        return HiveConstants.resetURLProtocol(dbURL, HS2_URL_PROTOCOL);
    }

    private static String resetURLProtocol(String dbURL, String toProtocol) {
        if (dbURL == null) {
            return dbURL;
        }
        String trimmedURL = dbURL.trim();
        if (trimmedURL.length() == 0 || trimmedURL.startsWith(toProtocol)) {
            return trimmedURL;
        }
        int slashIndex = trimmedURL.indexOf("//");
        if (slashIndex >= 0) {
            return String.valueOf(toProtocol) + trimmedURL.substring(slashIndex);
        }
        return trimmedURL;
    }
}

