/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.locking;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.locking.AbstractLockManager;
import me.prettyprint.cassandra.locking.HLockImpl;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.locking.HLock;
import me.prettyprint.hector.api.locking.HLockManagerConfigurator;
import me.prettyprint.hector.api.locking.HLockTimeoutException;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLockManagerImpl
extends AbstractLockManager {
    private static final Logger logger = LoggerFactory.getLogger(HLockManagerImpl.class);
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(this.lockManagerConfigurator.getNumberOfLockObserverThreads());
    private long lockTtl = this.lockManagerConfigurator.getLocksTTLInMillis();
    private int colTtl = (int)(this.lockTtl / 1000L);

    public HLockManagerImpl(Cluster cluster, HLockManagerConfigurator hlc) {
        super(cluster, hlc);
    }

    @Override
    public void acquire(HLock lock) {
        this.acquire(lock, Long.MAX_VALUE - System.currentTimeMillis() - 10000L);
    }

    @Override
    public void acquire(HLock lock, long timeout) {
        this.verifyPrecondition(lock);
        this.maybeSetInternalLockId(lock);
        this.writeLock(lock);
        Map<String, String> canBeEarlier = this.readExistingLocks(lock);
        if (canBeEarlier.size() <= 1) {
            this.setAcquired(lock, canBeEarlier);
            return;
        }
        String nextWaitingClientId = null;
        long waitStart = System.currentTimeMillis();
        while (true) {
            if (waitStart + timeout < System.currentTimeMillis()) {
                this.deleteLock(lock);
                throw new HLockTimeoutException(String.format("Unable to get lock before %d ", waitStart + timeout));
            }
            boolean recv_all_acks = true;
            for (Map.Entry<String, String> otherLock : canBeEarlier.entrySet()) {
                if (lock.getLockId().equals(otherLock.getKey()) || this.hasThisLockSeenMe(otherLock.getValue(), lock.getLockId())) continue;
                recv_all_acks = false;
                break;
            }
            ArrayList canBeEarlierSortedList = null;
            if (recv_all_acks) {
                canBeEarlierSortedList = Lists.newArrayList(canBeEarlier.keySet());
                Collections.sort(canBeEarlierSortedList);
                nextWaitingClientId = (String)canBeEarlierSortedList.get(0);
                if (nextWaitingClientId.equals(lock.getLockId())) break;
            }
            this.writeLock(lock, canBeEarlier.keySet());
            this.smartWait(this.lockManagerConfigurator.getBackOffRetryDelayInMillis());
            canBeEarlier = this.readExistingLocks(lock);
        }
        if (logger.isDebugEnabled()) {
            HLockManagerImpl.logLock(lock, canBeEarlier.keySet());
        }
        this.setAcquired(lock, canBeEarlier);
    }

    private void setAcquired(HLock lock, Map<String, String> canBeEarlier) {
        ScheduledFuture<Void> heartbeat = this.scheduler.schedule(new Heartbeat(lock), this.lockTtl / 2L, TimeUnit.MILLISECONDS);
        ((HLockImpl)lock).setHeartbeat(heartbeat);
        ((HLockImpl)lock).setAcquired(true);
        if (logger.isDebugEnabled()) {
            HLockManagerImpl.logLock(lock, canBeEarlier.keySet());
        }
    }

    private static void logLock(HLock lock, Set<String> earlier) {
        ArrayList canBeEarlierSortedList = Lists.newArrayList(earlier);
        Collections.sort(canBeEarlierSortedList);
        String peers = Joiner.on((String)", ").join((Iterable)canBeEarlierSortedList);
        logger.debug("{} acquired lock.  Peers are {}", (Object)lock, (Object)peers);
    }

    public void shutdownScheduler() {
        this.scheduler.shutdownNow();
    }

    private void smartWait(long sleepTime) {
        try {
            Thread.sleep(sleepTime + (long)(Math.random() * (double)sleepTime));
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while waiting", (Throwable)e);
        }
    }

    private boolean hasThisLockSeenMe(String commaSeparatedLockIds, String myLockId) {
        String[] seenLocksIds = commaSeparatedLockIds.split(",");
        for (int i = 0; i < seenLocksIds.length; ++i) {
            if (!seenLocksIds[i].equals(myLockId)) continue;
            return true;
        }
        return false;
    }

    private void maybeSetInternalLockId(HLock lock) {
        if (lock.getLockId() == null) {
            lock.setLockId(this.generateLockId());
        }
    }

    @Override
    public void release(HLock lock) {
        this.verifyPrecondition(lock);
        this.deleteLock(lock);
        ((HLockImpl)lock).setAcquired(false);
    }

    private String generateLockId() {
        return UUID.randomUUID().toString();
    }

    private void verifyPrecondition(HLock lock) {
        assert (lock != null);
        if (lock.getPath() == null) {
            throw new RuntimeException("Lock path cannot be null");
        }
    }

    private void writeLock(HLock lock) {
        this.writeLock(lock, lock.getLockId().toString());
    }

    private void writeLock(HLock lock, Set<String> keySet) {
        String seenLockIds = Joiner.on((String)",").join(keySet);
        this.writeLock(lock, seenLockIds);
    }

    private void writeLock(HLock lock, String seenLockIds) {
        Mutator<String> mutator = HFactory.createMutator(this.keyspace, StringSerializer.get());
        mutator.addInsertion(lock.getPath(), this.lockManagerConfigurator.getLockManagerCF(), this.createColumnForLock(lock.getLockId(), seenLockIds));
        mutator.execute();
    }

    private void deleteLock(HLock lock) {
        Future<Void> heartbeat = ((HLockImpl)lock).getHeartbeat();
        if (heartbeat != null) {
            heartbeat.cancel(false);
        }
        Mutator<String> mutator = HFactory.createMutator(this.keyspace, StringSerializer.get());
        mutator.addDeletion(lock.getPath(), this.lockManagerConfigurator.getLockManagerCF(), lock.getLockId(), StringSerializer.get(), this.keyspace.createClock());
        mutator.execute();
    }

    private Map<String, String> readExistingLocks(HLock lock) {
        SliceQuery<String, String, String> sliceQuery = HFactory.createSliceQuery(this.keyspace, StringSerializer.get(), StringSerializer.get(), StringSerializer.get()).setColumnFamily(this.lockManagerConfigurator.getLockManagerCF()).setKey(lock.getPath());
        sliceQuery.setRange(null, null, false, Integer.MAX_VALUE);
        QueryResult<ColumnSlice<String, String>> queryResult = sliceQuery.execute();
        return this.getResults(queryResult);
    }

    private Map<String, String> readExistingLocks(HLock lock, String lockName) {
        SliceQuery<String, String, String> sliceQuery = HFactory.createSliceQuery(this.keyspace, StringSerializer.get(), StringSerializer.get(), StringSerializer.get()).setColumnFamily(this.lockManagerConfigurator.getLockManagerCF()).setKey(lock.getPath());
        sliceQuery.setColumnNames((String[])new String[]{lockName});
        QueryResult<ColumnSlice<String, String>> queryResult = sliceQuery.execute();
        return this.getResults(queryResult);
    }

    private Map<String, String> getResults(QueryResult<ColumnSlice<String, String>> queryResult) {
        HashMap result = Maps.newHashMap();
        for (HColumn<String, String> col : queryResult.get().getColumns()) {
            result.put(col.getName(), col.getValue());
        }
        return result;
    }

    private HColumn<String, String> createColumnForLock(String name, String value) {
        return HFactory.createColumn(name, value, this.keyspace.createClock(), this.colTtl, StringSerializer.get(), StringSerializer.get());
    }

    @Override
    public HLock createLock(String lockPath) {
        return new HLockImpl(lockPath, this.generateLockId());
    }

    private class Heartbeat
    implements Callable<Void> {
        private HLock lock;

        private Heartbeat(HLock lock) {
            this.lock = lock;
        }

        @Override
        public Void call() throws Exception {
            logger.debug("{} heartbeat", (Object)this.lock);
            Map existing = HLockManagerImpl.this.readExistingLocks(this.lock, this.lock.getLockId());
            String values = (String)existing.get(this.lock.getLockId());
            if (values == null) {
                logger.debug("{} lock has been removed from cassandra.  Short circuiting", (Object)this.lock);
                return null;
            }
            HLockManagerImpl.this.writeLock(this.lock, values);
            HLockManagerImpl.this.scheduler.schedule(this, HLockManagerImpl.this.lockTtl / 2L, TimeUnit.MILLISECONDS);
            return null;
        }
    }
}

