/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.api.IChart;
import org.eclipse.birt.chart.script.api.IComponentFactory;
import org.eclipse.birt.chart.script.api.attribute.ILabel;
import org.eclipse.birt.chart.script.api.attribute.IText;
import org.eclipse.birt.chart.script.api.component.ILegend;
import org.eclipse.birt.chart.script.internal.ChartComponentFactory;
import org.eclipse.birt.chart.script.internal.ChartComponentUtil;
import org.eclipse.birt.chart.script.internal.component.LegendImpl;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.MultiRowItem;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

public abstract class ChartImpl
extends MultiRowItem
implements IChart {
    protected static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected Chart cm;
    protected ExtendedItemHandle eih;

    protected ChartImpl(ExtendedItemHandle eih, Chart cm) {
        super(eih);
        this.eih = eih;
        this.cm = cm;
    }

    @Override
    public IText getDescription() {
        Text desc = this.cm.getDescription();
        if (desc == null) {
            desc = ChartComponentUtil.createEMFText();
            this.cm.setDescription(desc);
        }
        return ChartComponentUtil.convertText(desc);
    }

    @Override
    public ILegend getLegend() {
        return new LegendImpl(this.cm.getLegend());
    }

    @Override
    public String getOutputType() {
        return (String)this.eih.getProperty("outputFormat");
    }

    @Override
    public ILabel getTitle() {
        Label title = this.cm.getTitle().getLabel();
        if (title == null) {
            title = ChartComponentUtil.createEMFLabel();
            this.cm.getTitle().setLabel(title);
        }
        return ChartComponentUtil.convertLabel(title);
    }

    @Override
    public boolean isColorByCategory() {
        return this.cm.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
    }

    @Override
    public void setColorByCategory(boolean byCategory) {
        this.cm.getLegend().setItemType(byCategory ? LegendItemType.CATEGORIES_LITERAL : LegendItemType.SERIES_LITERAL);
    }

    public void setDescription(IText label) {
        this.cm.setDescription(ChartComponentUtil.convertIText(label));
    }

    @Override
    public void setOutputType(String type) {
        try {
            if (!ChartUtil.isOutputFormatSupport((String)type)) {
                type = "SVG";
            }
            this.eih.setProperty("outputFormat", (Object)type);
        }
        catch (ChartException | SemanticException e) {
            logger.log((Exception)e);
        }
    }

    public void setTitle(ILabel title) {
        this.cm.getTitle().setLabel(ChartComponentUtil.convertILabel(title));
    }

    @Override
    public String getDimension() {
        return this.cm.getDimension().getName();
    }

    @Override
    public void setDimension(String dimensionName) {
        this.cm.setDimension(ChartDimension.getByName((String)dimensionName));
    }

    public void setWidth(double dimension) throws SemanticException {
        super.setWidth(dimension);
        double dWidth = this.convertDimensionToPoints(this.eih.getWidth());
        if (dWidth > 0.0) {
            this.cm.getBlock().getBounds().setWidth(dWidth);
        }
    }

    public void setWidth(String dimension) throws SemanticException {
        super.setWidth(dimension);
        double dWidth = this.convertDimensionToPoints(this.eih.getWidth());
        if (dWidth > 0.0) {
            this.cm.getBlock().getBounds().setWidth(dWidth);
        }
    }

    public void setHeight(double dimension) throws SemanticException {
        super.setHeight(dimension);
        double dHeight = this.convertDimensionToPoints(this.eih.getHeight());
        if (dHeight > 0.0) {
            this.cm.getBlock().getBounds().setHeight(dHeight);
        }
    }

    public void setHeight(String dimension) throws SemanticException {
        super.setHeight(dimension);
        double dHeight = this.convertDimensionToPoints(this.eih.getHeight());
        if (dHeight > 0.0) {
            this.cm.getBlock().getBounds().setHeight(dHeight);
        }
    }

    protected final double convertDimensionToPoints(DimensionHandle dh) throws SemanticException {
        double dOriginalMeasure = dh.getMeasure();
        String sUnits = dh.getUnits();
        if (sUnits != null) {
            if (sUnits == "px" || sUnits == "%") {
                throw new SemanticException("org.eclipse.birt.chart.reportitem", "ChartImpl.error.DimensionUnitNotSupported", new Object[]{sUnits}, Messages.getResourceBundle());
            }
            return DimensionUtil.convertTo((double)dOriginalMeasure, (String)sUnits, (String)"pt").getMeasure();
        }
        return 0.0;
    }

    @Override
    public IComponentFactory getFactory() {
        return new ChartComponentFactory();
    }
}

