/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.impl.MultiURLValuesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.HyperlinkEditorDialog;
import org.eclipse.birt.chart.ui.swt.composites.MenuStylesDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.util.TriggerSupportMatrix;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MultipleHyperlinksComposite
extends Composite
implements Listener {
    private org.eclipse.swt.widgets.List fListHyperlinks;
    private Button fBtnAdd;
    private Button fBtnEdit;
    private Button fBtnDelete;
    private Button fBtnProperties;
    Text fTxtTooltip;
    private ChartWizardContext fContext;
    MultiURLValues fMultiURLValues;
    private TriggerSupportMatrix fTriggerMatrix;
    private int fOptionalStyles;
    private Map<String, URLValue> fURLValuesMap = new HashMap<String, URLValue>();
    private Button fBtnUp;
    private Button fBtnDown;

    public MultipleHyperlinksComposite(Composite parent, int style, ChartWizardContext context, TriggerSupportMatrix triggerMatrix, int optionalStyles) {
        super(parent, style);
        this.fContext = context;
        this.fTriggerMatrix = triggerMatrix;
        this.fOptionalStyles = optionalStyles;
        this.placeComponents();
        this.initListeners();
        this.updateButtonStatus();
    }

    public void populateUIValues(MultiURLValues urlValues) {
        this.fListHyperlinks.removeAll();
        this.fURLValuesMap.clear();
        this.setURLValues(urlValues);
        if (this.fMultiURLValues == null) {
            this.fMultiURLValues = MultiURLValuesImpl.create();
        }
        EList urlValuies = this.fMultiURLValues.getURLValues();
        String[] items = new String[urlValuies.size()];
        int i = 0;
        for (URLValue uv : urlValuies) {
            String text = uv.getLabel().getCaption().getValue();
            if (text == null) {
                text = uv.getBaseUrl();
            }
            items[i] = text;
            this.fListHyperlinks.add(text);
            this.fURLValuesMap.put(text, uv);
            ++i;
        }
        if (this.fMultiURLValues.getTooltip() != null) {
            this.fTxtTooltip.setText(this.fMultiURLValues.getTooltip());
        }
        this.updateButtonStatus();
    }

    private void placeComponents() {
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.setLayout((Layout)gl);
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString("MultipleHyperlinksComposite.Group.Hyperlinks"));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 3;
        group.setLayout((Layout)gl);
        this.fListHyperlinks = new org.eclipse.swt.widgets.List((Composite)group, 2820);
        gd = new GridData(1808);
        gd.heightHint = 80;
        gd.widthHint = 100;
        gd.horizontalSpan = 3;
        this.fListHyperlinks.setLayoutData((Object)gd);
        this.fBtnAdd = new Button((Composite)group, 0);
        this.fBtnAdd.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Add"));
        gd = new GridData(768);
        this.fBtnAdd.setLayoutData((Object)gd);
        this.fBtnEdit = new Button((Composite)group, 0);
        this.fBtnEdit.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Edit"));
        gd = new GridData(768);
        this.fBtnEdit.setLayoutData((Object)gd);
        this.fBtnDelete = new Button((Composite)group, 0);
        this.fBtnDelete.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Delete"));
        gd = new GridData(768);
        this.fBtnDelete.setLayoutData((Object)gd);
        this.fBtnUp = new Button((Composite)group, 0);
        this.fBtnUp.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Up"));
        gd = new GridData(768);
        this.fBtnUp.setLayoutData((Object)gd);
        this.fBtnDown = new Button((Composite)group, 0);
        this.fBtnDown.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Down"));
        gd = new GridData(768);
        this.fBtnDown.setLayoutData((Object)gd);
        new Label((Composite)group, 0);
        this.fBtnProperties = new Button((Composite)this, 0);
        this.fBtnProperties.setText(Messages.getString("MultipleHyperlinksComposite.Btn.Properties"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fBtnProperties.setLayoutData((Object)gd);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("MultipleHyperlinksComposite.Label.Tooltip"));
        this.fTxtTooltip = new Text((Composite)this, 2048);
        gd = new GridData(768);
        gd.widthHint = 150;
        this.fTxtTooltip.setLayoutData((Object)gd);
    }

    private void initListeners() {
        this.fListHyperlinks.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                MultipleHyperlinksComposite.this.doEdit();
            }
        });
        this.fListHyperlinks.addListener(13, (Listener)this);
        this.fBtnAdd.addListener(13, (Listener)this);
        this.fBtnEdit.addListener(13, (Listener)this);
        this.fBtnDelete.addListener(13, (Listener)this);
        this.fBtnUp.addListener(13, (Listener)this);
        this.fBtnDown.addListener(13, (Listener)this);
        this.fBtnProperties.addListener(13, (Listener)this);
        this.fTxtTooltip.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MultipleHyperlinksComposite.this.fMultiURLValues.setTooltip(MultipleHyperlinksComposite.this.fTxtTooltip.getText());
            }
        });
    }

    private void updateButtonStatus() {
        if (this.fListHyperlinks.isDisposed()) {
            return;
        }
        int index = this.fListHyperlinks.getSelectionIndex();
        boolean enabled = index >= 0;
        this.fBtnEdit.setEnabled(enabled);
        this.fBtnDelete.setEnabled(enabled);
        this.fBtnUp.setEnabled(enabled && index > 0);
        this.fBtnDown.setEnabled(enabled && index < this.fListHyperlinks.getItemCount() - 1);
        this.fBtnProperties.setEnabled(this.fMultiURLValues != null && this.fMultiURLValues.getURLValues().size() > 1);
    }

    private void doAdd() {
        HyperlinkEditorDialog dialog = new HyperlinkEditorDialog(this.getShell(), null, this.fContext, this.fTriggerMatrix, this.fOptionalStyles);
        List<String> labels = Arrays.asList(this.fListHyperlinks.getItems());
        dialog.setExistingLabels(labels);
        if (dialog.open() == 0) {
            URLValue value = dialog.getURLValue();
            this.fMultiURLValues.getURLValues().add((Object)value);
            value.eAdapters().addAll((Collection)this.fMultiURLValues.eAdapters());
            String text = value.getLabel().getCaption().getValue();
            this.fListHyperlinks.add(text);
            this.fURLValuesMap.put(text, value);
        }
        this.fListHyperlinks.setSelection(this.fListHyperlinks.getItemCount() - 1);
    }

    void doEdit() {
        String text;
        int selectionIndex = this.fListHyperlinks.getSelectionIndex();
        if (selectionIndex < 0) {
            return;
        }
        URLValue value = this.fURLValuesMap.get(this.fListHyperlinks.getItem(selectionIndex));
        String oldText = value.getLabel().getCaption().getValue();
        HyperlinkEditorDialog dialog = new HyperlinkEditorDialog(this.getShell(), value, this.fContext, this.fTriggerMatrix, this.fOptionalStyles);
        ArrayList<String> labels = new ArrayList<String>(Arrays.asList(this.fListHyperlinks.getItems()));
        labels.remove(value.getLabel().getCaption().getValue());
        dialog.setExistingLabels(labels);
        if (dialog.open() == 0 && !oldText.equals(text = value.getLabel().getCaption().getValue())) {
            this.fListHyperlinks.setItem(selectionIndex, text);
            this.fURLValuesMap.remove(oldText);
            this.fURLValuesMap.put(text, value);
        }
    }

    private void doDelete() {
        int index = this.fListHyperlinks.getSelectionIndex();
        if (index < 0) {
            return;
        }
        URLValue value = this.fURLValuesMap.remove(this.fListHyperlinks.getItem(index));
        this.fMultiURLValues.getURLValues().remove((Object)value);
        this.fListHyperlinks.remove(index);
        int last = this.fListHyperlinks.getItemCount() - 1;
        this.fListHyperlinks.select(index < last ? index : last);
    }

    private void doDown() {
        int index = this.fListHyperlinks.getSelectionIndex();
        if (index < this.fListHyperlinks.getItemCount() - 1) {
            this.fMultiURLValues.getURLValues().add(index + 1, (Object)((URLValue)this.fMultiURLValues.getURLValues().remove(index)));
            String item = this.fListHyperlinks.getItem(index);
            this.fListHyperlinks.remove(index);
            this.fListHyperlinks.add(item, index + 1);
            this.fListHyperlinks.setSelection(index + 1);
        }
    }

    private void doUp() {
        int index = this.fListHyperlinks.getSelectionIndex();
        if (index > 0) {
            this.fMultiURLValues.getURLValues().add(index - 1, (Object)((URLValue)this.fMultiURLValues.getURLValues().remove(index)));
            String item = this.fListHyperlinks.getItem(index);
            this.fListHyperlinks.remove(index);
            this.fListHyperlinks.add(item, index - 1);
            this.fListHyperlinks.setSelection(index - 1);
        }
    }

    private void editProperties() {
        MenuStylesDialog dialog = new MenuStylesDialog(this.getShell(), (EMap<String, String>)this.fMultiURLValues.getPropertiesMap());
        dialog.open();
    }

    public MultiURLValues getURLValues() {
        return this.fMultiURLValues;
    }

    public void setURLValues(MultiURLValues urlValues) {
        this.fMultiURLValues = urlValues;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fBtnAdd) {
            this.doAdd();
        } else if (source == this.fBtnEdit) {
            this.doEdit();
        } else if (source == this.fBtnDelete) {
            this.doDelete();
        } else if (source == this.fBtnUp) {
            this.doUp();
        } else if (source == this.fBtnDown) {
            this.doDown();
        } else if (source == this.fBtnProperties) {
            this.editProperties();
        }
        this.updateButtonStatus();
    }
}

