/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.cache.CursorableList;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BorderConflictResolver;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.DummyCell;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public class TableLayout {
    protected CursorableList rows = new CursorableList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    protected TableArea.TableLayoutInfo layoutInfo = null;
    protected ITableContent tableContent;
    protected int startCol;
    protected int endCol;
    protected RowArea unresolvedRow;
    private RowArea currentRow;
    private boolean isRTL = false;

    public TableLayout(ITableContent tableContent, TableArea.TableLayoutInfo layoutInfo, int startCol, int endCol) {
        this.tableContent = tableContent;
        this.layoutInfo = layoutInfo;
        this.startCol = startCol;
        this.endCol = endCol;
        if (tableContent != null) {
            this.isRTL = tableContent.isRTL();
        }
    }

    public void setUnresolvedRow(RowArea row) {
        if (row != null && this.isUnresolved(row)) {
            this.unresolvedRow = row;
        }
    }

    public RowArea getNextRow(RowArea row) {
        int index = this.rows.indexOf(row);
        if (index >= 0 && index <= this.rows.size() - 2) {
            return (RowArea)this.rows.get(index + 1);
        }
        return null;
    }

    protected int resolveBottomBorder(CellArea cell) {
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IContent cellContent = cell.getContent();
        IStyle columnStyle = this.getColumnStyle(cell.getColumnID());
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
        if (tableStyle != null && rowStyle != null && columnStyle != null && cellContentStyle != null) {
            return 0;
        }
        BorderInfo border = this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle);
        if (border != null) {
            if (cell.getBoxStyle() == BoxStyle.DEFAULT) {
                cell.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
            }
            cell.getBoxStyle().setBottomBorder(border);
            return border.getWidth();
        }
        return 0;
    }

    protected void add(ContainerArea area, ArrayList rows) {
        if (area instanceof RowArea) {
            rows.add(area);
        } else {
            Iterator<IArea> iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.add(container, rows);
            }
        }
    }

    public void remove(TableArea table) {
        ArrayList rowCollection = new ArrayList();
        this.add(table, rowCollection);
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            RowArea row = (RowArea)iter.next();
            if (!rowCollection.contains(row)) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public void clear() {
        this.rows.clear();
        this.rows.resetCursor();
    }

    protected IStyle getLeftCellContentStyle(RowArea lastRow, CellArea currentCell) {
        RowArea currentRow = (RowArea)currentCell.getParent();
        int columnID = currentCell.getColumnID();
        CellArea cell = null;
        cell = currentRow.getCell(columnID - 1);
        if (cell == null && lastRow != null) {
            cell = lastRow.getCell(columnID - 1);
        }
        if (cell != null) {
            return cell.getContent().getComputedStyle();
        }
        return null;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        BorderInfo border;
        IContent cellContent = cellArea.getContent();
        int columnID = cellArea.getColumnID();
        int colSpan = cellArea.getColSpan();
        IRowContent row = (IRowContent)cellContent.getParent();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = row.getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(columnID);
        IStyle preRowStyle = null;
        IStyle preColumnStyle = this.getColumnStyle(columnID - 1);
        IStyle leftCellContentStyle = null;
        IStyle topCellStyle = null;
        ContainerArea lastRow = null;
        if (this.rows.size() > 0) {
            lastRow = (RowArea)this.rows.getCurrent();
        }
        if (lastRow != null) {
            preRowStyle = lastRow.getContent().getComputedStyle();
            CellArea cell = ((RowArea)lastRow).getCell(columnID);
            if (cell != null && cell.getContent() != null) {
                topCellStyle = cell.getContent().getComputedStyle();
            }
        }
        if (columnID > this.startCol) {
            leftCellContentStyle = this.getLeftCellContentStyle((RowArea)lastRow, cellArea);
        }
        if (this.rows.size() == 0 && lastRow == null) {
            if (isFirst) {
                if ((tableStyle != null || rowStyle != null || cellContentStyle != null) && (border = this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setTopBorder(border);
                }
            } else if (tableStyle != null && (border = this.bcr.resolveTableTopBorder(tableStyle, null, columnStyle, null)) != null) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setTopBorder(border);
            }
            if (columnID == this.startCol && !this.isRTL || columnID + colSpan - 1 == this.endCol && this.isRTL) {
                if ((tableStyle != null || rowStyle != null || cellContentStyle != null) && (border = this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setLeftBorder(border);
                }
            } else if (!(this.isRTL || leftCellContentStyle == null && cellContentStyle == null || (border = this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle)) == null)) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setLeftBorder(border);
            }
            if (columnID + colSpan - 1 == this.endCol && !this.isRTL || columnID == this.startCol && this.isRTL) {
                if ((tableStyle != null || rowStyle != null || cellContentStyle != null) && (border = this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setRightBorder(border);
                }
            } else if (this.isRTL && columnID > this.startCol && (leftCellContentStyle != null || cellContentStyle != null) && (border = this.bcr.resolveCellLeftBorder(columnStyle, preColumnStyle, cellContentStyle, leftCellContentStyle)) != null) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setRightBorder(border);
            }
        } else {
            if (isFirst) {
                if ((preRowStyle != null || rowStyle != null || topCellStyle != null || cellContentStyle != null) && (border = this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setTopBorder(border);
                }
            } else if ((preRowStyle != null || topCellStyle != null) && (border = this.bcr.resolveCellTopBorder(preRowStyle, null, topCellStyle, null)) != null) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setTopBorder(border);
            }
            if (columnID == this.startCol && !this.isRTL || columnID + colSpan - 1 == this.endCol && this.isRTL) {
                if ((tableStyle != null || rowStyle != null || cellContentStyle != null) && (border = this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setLeftBorder(border);
                }
            } else if (!(this.isRTL || leftCellContentStyle == null && cellContentStyle == null || (border = this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle)) == null)) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setLeftBorder(border);
            }
            if (columnID + colSpan - 1 == this.endCol && !this.isRTL || columnID == this.startCol && this.isRTL) {
                if ((tableStyle != null || rowStyle != null || cellContentStyle != null) && (border = this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle)) != null) {
                    if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                        cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                    }
                    cellArea.getBoxStyle().setRightBorder(border);
                }
            } else if (this.isRTL && columnID > this.startCol && (leftCellContentStyle != null || cellContentStyle != null) && (border = this.bcr.resolveCellLeftBorder(columnStyle, preColumnStyle, cellContentStyle, leftCellContentStyle)) != null) {
                if (cellArea.getBoxStyle() == BoxStyle.DEFAULT) {
                    cellArea.setBoxStyle(new BoxStyle(BoxStyle.DEFAULT));
                }
                cellArea.getBoxStyle().setRightBorder(border);
            }
        }
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    private int getAllocatedHeight(AbstractArea area) {
        if (area instanceof ContainerArea) {
            return ((ContainerArea)area).getAllocatedHeight();
        }
        return area.getHeight();
    }

    private int getAllocatedWidth(AbstractArea area) {
        if (area instanceof ContainerArea) {
            return ((ContainerArea)area).getAllocatedWidth();
        }
        return area.getWidth();
    }

    protected void align(CellArea cell) {
        CSSValue align;
        boolean isRightAligned;
        IContent content = cell.getContent();
        if (content == null) {
            return;
        }
        CSSValue verticalAlign = content.getComputedStyle().getProperty(48);
        if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
            int totalHeight = 0;
            Iterator<IArea> iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += this.getAllocatedHeight(child);
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                AbstractArea child;
                int y;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    y = cell.getOffsetY() + offset;
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedY(y);
                        y += child.getAllocatedHeight();
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    y = cell.getOffsetY() + offset / 2;
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedY(y);
                        y += child.getAllocatedHeight();
                    }
                }
            }
        }
        if ((isRightAligned = BidiAlignmentResolver.isRightAligned(content, align = content.getComputedStyle().getProperty(23), false)) || IStyle.CENTER_VALUE.equals(align)) {
            Iterator<IArea> iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = cell.getContentWidth() - this.getAllocatedWidth(area);
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    area.setAllocatedX(spacing + cell.getOffsetX());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedX(spacing / 2 + cell.getOffsetX());
            }
        }
    }

    public void reset(TableArea table) {
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            RowArea row = (RowArea)iter.next();
            if (!table.contains(row)) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public int resolveAll(RowArea row) {
        int originalRowHeight;
        if (row == null || this.rows.size() == 0) {
            return 0;
        }
        int height = originalRowHeight = row.getHeight();
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    DummyCell dummyCell = (DummyCell)cell;
                    int n = dummyCell.getDelta();
                } else {
                    height = Math.max(height, cell.getHeight());
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        int dValue = height - originalRowHeight;
        int i2 = this.startCol;
        while (i2 <= this.endCol) {
            CellArea cell = row.getCell(i2);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    CellArea refCell;
                    int delta = ((DummyCell)cell).getDelta();
                    if (cell.getRowSpan() == 1) {
                        refCell = ((DummyCell)cell).getCell();
                        refCell.setHeight(delta + height);
                        this.align(refCell);
                    } else {
                        refCell = ((DummyCell)cell).getCell();
                        refCell.setHeight(delta + height);
                        this.align(refCell);
                    }
                } else {
                    int oh = cell.getHeight();
                    cell.setHeight(height);
                    if (oh != height) {
                        this.align(cell);
                    }
                }
                i2 = i2 + cell.getColSpan() - 1;
            }
            ++i2;
        }
        row.setHeight(height);
        return dValue;
    }

    public int resolveBottomBorder() {
        CellArea cell;
        if (this.rows.size() == 0) {
            return 0;
        }
        RowArea row = (RowArea)this.rows.getCurrent();
        int result = 0;
        int width = 0;
        int i = this.startCol;
        while (i <= this.endCol) {
            cell = row.getCell(i);
            if (cell != null) {
                width = cell instanceof DummyCell ? this.resolveBottomBorder(((DummyCell)cell).getCell()) : this.resolveBottomBorder(cell);
                if (width > result) {
                    result = width;
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
        if (result > 0) {
            row.setHeight(row.getHeight() + result);
            i = this.startCol;
            while (i <= this.endCol) {
                cell = row.getCell(i);
                if (cell != null) {
                    if (cell instanceof DummyCell) {
                        CellArea oc = ((DummyCell)cell).getCell();
                        oc.setHeight(oc.getHeight() + result);
                    } else {
                        cell.setHeight(cell.getHeight() + result);
                    }
                    i = i + cell.getColSpan() - 1;
                }
                ++i;
            }
        }
        return result;
    }

    public void addRows(CursorableList rs) {
        Iterator iter = rs.iterator();
        while (iter.hasNext()) {
            this.rows.add(iter.next());
        }
    }

    public void addRow(RowArea rowArea, boolean isFixedLayout) {
        this.updateRow(rowArea, isFixedLayout);
        this.rows.add(rowArea);
    }

    protected boolean isUnresolved(RowArea row) {
        if (!row.finished) {
            return true;
        }
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null && cell.getRowSpan() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setMergeUnresolvedRowHint() {
        RowArea lastRow = (RowArea)this.rows.getCurrent();
        if (this.unresolvedRow != null && lastRow != null && this.isUnresolved(this.unresolvedRow)) {
            int i = this.startCol;
            while (i <= this.endCol) {
                CellArea unresolvedCell;
                CellArea cell = lastRow.getCell(i);
                if (cell != null && (unresolvedCell = this.unresolvedRow.getCell(i)) != null) {
                    cell.setRowSpan(unresolvedCell.getRowSpan() - (this.unresolvedRow.finished ? 0 : -1));
                }
                ++i;
            }
            this.unresolvedRow = null;
        }
    }

    protected boolean isSpecifiedHeight(RowArea area) {
        DimensionType cHeight;
        IContent content = area.getContent();
        return content != null && (cHeight = content.getHeight()) != null && !cHeight.getUnits().equals("%");
    }

    private void updateRow(RowArea rowArea, boolean isFixedLayout) {
        int sheight;
        if (this.unresolvedRow != null && !this.unresolvedRow.finished) {
            int i = this.startCol;
            while (i <= this.endCol) {
                CellArea cell = this.unresolvedRow.getCell(i);
                if (cell != null) {
                    cell.setRowSpan(cell.getRowSpan() + 1);
                    i += cell.getColSpan();
                }
                ++i;
            }
        }
        RowArea lastRow = null;
        if (this.rows.size() > 0) {
            lastRow = (RowArea)this.rows.getCurrent();
        }
        this.currentRow = rowArea;
        int height = sheight = rowArea.getSpecifiedHeight();
        if (lastRow == null) {
            int i = this.startCol;
            while (i <= this.endCol) {
                CellArea cell;
                CellArea upperCell = null;
                if (this.unresolvedRow != null) {
                    upperCell = this.unresolvedRow.getCell(i);
                }
                if ((cell = this.currentRow.getCell(i)) == null) {
                    cell = this.createEmptyCell(upperCell, i, rowArea);
                } else {
                    if (!(cell.getRowSpan() != 1 || isFixedLayout && sheight != 0)) {
                        height = Math.max(height, cell.getHeight());
                    }
                    i = i + cell.getColSpan() - 1;
                }
                ++i;
            }
        } else {
            int i = this.startCol;
            while (i <= this.endCol) {
                CellArea upperCell = lastRow.getCell(i);
                CellArea cell = this.currentRow.getCell(i);
                if (upperCell != null && upperCell.getRowSpan() > 1) {
                    if (rowArea.cells[i] != null) {
                        rowArea.removeChild(rowArea.cells[i]);
                    }
                    DummyCell dummyCell = this.createDummyCell(upperCell, lastRow);
                    rowArea.setCell(dummyCell);
                    int delta = dummyCell.getDelta();
                    if (!(dummyCell.getRowSpan() != 1 || isFixedLayout && sheight != 0)) {
                        height = Math.max(height, dummyCell.getCell().getHeight() - delta);
                    }
                    i = i + upperCell.getColSpan() - 1;
                } else {
                    if (cell == null) {
                        if (this.unresolvedRow != null) {
                            upperCell = this.unresolvedRow.getCell(i);
                            cell = this.createEmptyCell(upperCell, i, rowArea);
                        } else {
                            cell = this.createEmptyCell(null, i, rowArea);
                        }
                    }
                    if (cell != null) {
                        if (cell.getRowSpan() == 1 && (!isFixedLayout || sheight == 0 && !this.isSpecifiedHeight(rowArea))) {
                            height = Math.max(height, cell.getHeight());
                        }
                        i = i + cell.getColSpan() - 1;
                    }
                }
                ++i;
            }
        }
        if (this.unresolvedRow != null) {
            this.unresolvedRow = null;
        }
        this.updateRowHeight(rowArea, height, isFixedLayout);
    }

    private CellArea createEmptyCell(CellArea upperCell, int columnId, RowArea row) {
        ICellContent cellContent = null;
        int rowSpan = 1;
        if (upperCell != null) {
            cellContent = (ICellContent)upperCell.getContent();
            rowSpan = upperCell.getRowSpan() - 1;
        }
        if (cellContent == null) {
            cellContent = this.tableContent.getReportContent().createCellContent();
            cellContent.setColumn(columnId);
            cellContent.setColSpan(1);
            cellContent.setRowSpan(1);
            cellContent.setParent(row.getContent());
        }
        int emptyCellColID = cellContent.getColumn();
        int emptyCellColSpan = cellContent.getColSpan();
        CellArea emptyCell = null;
        if (upperCell != null) {
            emptyCell = upperCell.cloneArea();
        } else {
            emptyCell = new CellArea();
            emptyCell.content = cellContent;
        }
        BoxStyle bs = emptyCell.getBoxStyle();
        if (bs != BoxStyle.DEFAULT) {
            bs.setRightBorder(null);
            bs.setBottomBorder(null);
        }
        emptyCell.setHeight(0);
        emptyCell.setRowSpan(rowSpan);
        CellArea originalCell = upperCell;
        if (upperCell instanceof DummyCell) {
            originalCell = ((DummyCell)upperCell).getCell();
        }
        CellArea leftSideCellArea = null;
        if (emptyCellColID > this.startCol) {
            leftSideCellArea = row.getCell(emptyCellColID - 1);
            if (leftSideCellArea == null) {
                int k = emptyCellColID - 1;
                while (leftSideCellArea == null && k > this.startCol) {
                    leftSideCellArea = row.getCell(--k);
                }
            }
        } else {
            leftSideCellArea = null;
        }
        emptyCell.setParent(row);
        row.setCell(emptyCell);
        this.resolveBorderConflict(emptyCell, true);
        emptyCell.setWidth(this.getCellWidth(emptyCellColID, emptyCellColID + emptyCellColSpan));
        emptyCell.setPosition(this.layoutInfo.getXPosition(columnId), 0);
        if (leftSideCellArea != null) {
            int index = row.indexOf(leftSideCellArea);
            row.addChild(index + 1, emptyCell);
        } else {
            row.addChild(0, emptyCell);
        }
        emptyCell.isDummy = true;
        return emptyCell;
    }

    private DummyCell createDummyCell(CellArea upperCell, RowArea lastRow) {
        DummyCell dummyCell = null;
        CellArea refCell = null;
        int lastRowHeight = lastRow.getHeight();
        int delta = 0;
        if (upperCell instanceof DummyCell) {
            refCell = ((DummyCell)upperCell).getCell();
            dummyCell = new DummyCell(refCell);
            delta = ((DummyCell)upperCell).getDelta() + lastRowHeight;
            dummyCell.setDelta(delta);
        } else {
            refCell = upperCell;
            dummyCell = new DummyCell(upperCell);
            dummyCell.setDelta(lastRowHeight);
        }
        int rowSpan = upperCell.getRowSpan() - 1;
        if (this.unresolvedRow != null) {
            CellArea cell = this.unresolvedRow.getCell(upperCell.getColumnID());
            rowSpan = cell.getRowSpan() - (this.unresolvedRow.finished ? 1 : 0);
        }
        dummyCell.setRowSpan(rowSpan);
        dummyCell.setColSpan(upperCell.getColSpan());
        dummyCell.isDummy = true;
        return dummyCell;
    }

    private void updateRowHeight(RowArea row, int height, boolean isFixedLayout) {
        if (height < 0) {
            return;
        }
        row.setHeight(height);
        int i = this.startCol;
        while (i <= this.endCol) {
            CellArea cell = row.getCell(i);
            if (cell != null) {
                if (cell.getRowSpan() == 1) {
                    if (cell instanceof DummyCell) {
                        CellArea refCell = ((DummyCell)cell).getCell();
                        int delta = ((DummyCell)cell).getDelta();
                        refCell.setHeight(delta + height);
                        this.align(refCell);
                    } else {
                        int cellHeight = cell.getHeight();
                        cell.setHeight(height);
                        this.align(cell);
                        if (isFixedLayout && cellHeight > height) {
                            cell.setNeedClip(true);
                        }
                    }
                }
                i = i + cell.getColSpan() - 1;
            }
            ++i;
        }
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public CursorableList getRows() {
        return this.rows;
    }
}

