/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.util;

import org.eclipse.core.runtime.Assert;

public class DataProtocolUtil {
    public static final String DATA_PROTOCOL = "data:";
    private static final char ENCODING_AND_PARAMETER_START_CHAR = ';';
    private static final char ENCODING_TERMINATION_CHAR = ',';
    private static final String DEFAULT_MEDIA_TYPE = "text/plain;charset=US-ASCII";

    public static DataUrlInfo parseDataUrl(String url) {
        Assert.isNotNull((Object)url);
        if (url != null && url.startsWith(DATA_PROTOCOL)) {
            String nonDataPart = "";
            String mimeTypePart = DEFAULT_MEDIA_TYPE;
            String dataPart = "";
            String encodingPart = null;
            int posOfDataMarker = url.indexOf(44);
            if (posOfDataMarker > -1) {
                nonDataPart = url.substring(DATA_PROTOCOL.length(), posOfDataMarker);
                dataPart = url.substring(posOfDataMarker + 1);
                int startSearchPos = nonDataPart.length() - 1;
                int mimeTypeEndPos = nonDataPart.lastIndexOf(59, startSearchPos);
                if (mimeTypeEndPos > -1) {
                    mimeTypePart = nonDataPart.substring(0, mimeTypeEndPos);
                    encodingPart = nonDataPart.substring(mimeTypeEndPos + 1);
                    int equalsPos = encodingPart.indexOf(61);
                    if (equalsPos > -1) {
                        mimeTypePart = String.valueOf(mimeTypePart) + ';' + encodingPart;
                        encodingPart = null;
                    }
                } else {
                    mimeTypePart = nonDataPart;
                }
                return new DataUrlInfo(mimeTypePart, encodingPart, dataPart);
            }
        }
        throw new IllegalArgumentException("URL is not of right format");
    }

    public static class DataUrlInfo {
        private String mediaType;
        private String encoding;
        private String data;

        DataUrlInfo(String mediaType, String encoding, String data) {
            this.mediaType = mediaType;
            this.encoding = encoding;
            this.data = data;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String getData() {
            return this.data;
        }
    }
}

