/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.LayoutModuleHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.LayoutModule;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.ILibraryModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.StyleUtil;

public abstract class LibraryHandleImpl
extends LayoutModuleHandle
implements ILibraryModel {
    public LibraryHandleImpl(Module module) {
        super(module);
    }

    public ModuleHandle getHostHandle() {
        LayoutModule host = ((Library)this.getElement()).getHost();
        if (host == null) {
            return null;
        }
        return (ModuleHandle)host.getHandle(this.getModule());
    }

    public String getNamespace() {
        return ((Library)this.module).getNamespace();
    }

    public SlotHandle getThemes() {
        return this.getSlot(0);
    }

    @Override
    @Deprecated
    public SlotHandle getStyles() {
        ThemeHandle theme = this.getTheme();
        if (theme == null) {
            return null;
        }
        return theme.getStyles();
    }

    @Override
    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        String themeName = ((Module)this.getElement()).getThemeName();
        if (themeName == null) {
            themeName = CommandLabelFactory.getCommandLabel("Theme.defaultThemeName");
        }
        this.importCssStyles(stylesheet, selectedStyles, themeName);
    }

    private ThemeHandle setupTheme(String themeName) {
        Theme theme;
        block7: {
            Library libElement = (Library)this.getElement().getRoot();
            theme = libElement.findNativeTheme(themeName);
            if (theme == null) {
                ThemeHandle newTheme;
                block6: {
                    newTheme = this.getModuleHandle().getElementFactory().newTheme(themeName);
                    try {
                        this.getThemes().add(newTheme);
                    }
                    catch (ContentException | NameException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
                theme = (Theme)newTheme.getElement();
            }
            try {
                if (libElement.getThemeName() == null) {
                    this.setThemeName(themeName);
                }
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return (ThemeHandle)theme.getHandle(this.module);
    }

    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles, String themeName) {
        if (StringUtil.isBlank(themeName)) {
            return;
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ImportCSSStyles"));
        ThemeHandle themeHandle = this.setupTheme(themeName);
        int i = 0;
        while (i < selectedStyles.size()) {
            block6: {
                SharedStyleHandle style = (SharedStyleHandle)selectedStyles.get(i);
                if (stylesheet.findStyle(style.getName()) != null) {
                    try {
                        SharedStyleHandle newStyle = StyleUtil.transferCssStyleToSharedStyle(this.module, style);
                        if (newStyle != null) {
                            newStyle.getElement().setName(themeHandle.makeUniqueStyleName(newStyle.getName()));
                            themeHandle.getStyles().add(newStyle);
                        }
                    }
                    catch (ContentException | NameException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError();
                    }
                }
            }
            ++i;
        }
        stack.commit();
    }

    @Override
    public SlotHandle getCubes() {
        return this.getSlot(6);
    }

    public String getRelativeFileName() {
        ModuleHandle hostHandle = this.getHostHandle();
        if (hostHandle == null) {
            return null;
        }
        Module host = (Module)hostHandle.getElement();
        if (host == null) {
            return null;
        }
        IncludedLibrary libStruct = host.findIncludedLibrary(this.getNamespace());
        if (libStruct != null) {
            return libStruct.getFileName();
        }
        return null;
    }

    @Override
    public boolean isDirectionRTL() {
        return false;
    }
}

