/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public abstract class AbstractDiagram {
    static final Set<Character> FORBIDDEN = Set.of(Character.valueOf('\\'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('#'), Character.valueOf('~'), Character.valueOf('\u00a7'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'));
    private StringBuilder diagramBuilder = new StringBuilder();
    private BiMap<Object, String> idMap = HashBiMap.create();

    public void resetDiagramData() {
        this.diagramBuilder = new StringBuilder();
        this.idMap = HashBiMap.create();
    }

    public void append(CharSequence chars) {
        this.diagramBuilder.append(chars);
    }

    public void append(String str) {
        this.diagramBuilder.append(str);
    }

    public void appendName(String name) {
        this.diagramBuilder.append("\"");
        this.diagramBuilder.append(this.clean(name));
        this.diagramBuilder.append("\"");
    }

    private CharSequence clean(String str) {
        if (str == null || str.isEmpty()) {
            return "???";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = str.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(FORBIDDEN.contains(Character.valueOf(c)) ? (char)'_' : c);
            ++n2;
        }
        return sb;
    }

    public void appendId(Object obj) {
        this.diagramBuilder.append(this.getOrCreateId(obj));
    }

    public void appendUrl(Object obj) {
        this.diagramBuilder.append(", URL=\"#" + this.getOrCreateId(obj) + "\"");
    }

    public String getDiagramText() {
        return this.diagramBuilder.toString();
    }

    public String getOrCreateId(Object obj) {
        return (String)this.idMap.computeIfAbsent(obj, k -> "obj" + this.idMap.size());
    }

    public Object getObjectById(String id) {
        return this.idMap.inverse().get((Object)id);
    }

    public String getGraphvizPath() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sourceforge.plantuml.eclipse");
        String dotPath1 = prefs.get("graphvizPath", null);
        if (dotPath1 != null && !dotPath1.isEmpty()) {
            return dotPath1;
        }
        String dotPath2 = System.getenv("GRAPHVIZ_DOT");
        if (dotPath2 != null && !dotPath2.isEmpty()) {
            return dotPath2;
        }
        if (Platform.getOS().equals("win32")) {
            return "dot.exe";
        }
        return "dot";
    }

    public abstract String renderToSvg() throws IOException;
}

