/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EventModelFactory;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;
import org.eclipse.emf.common.util.EMap;

public class EMVariableRate
implements IEventModel {
    private Time tStep;
    private double dLowerBoundOccurrences;
    private double dUpperBoundOccurrences;
    private double dAverageBoundOccurrences;

    @Override
    public long etaPlus(Time dt) {
        if (EventModelFactory.isNullOrZero(dt)) {
            return 0L;
        }
        double result = dt.multiply(this.dUpperBoundOccurrences).divide(this.tStep);
        return (long)Math.ceil(result);
    }

    @Override
    public long etaMinus(Time dt) {
        if (EventModelFactory.isNullOrZero(dt)) {
            return 0L;
        }
        double result = dt.multiply(this.dLowerBoundOccurrences).divide(this.tStep);
        return (long)result;
    }

    @Override
    public Time deltaPlus(long n) {
        if (n < 2L) {
            return null;
        }
        double scale = (double)(n - 1L) / this.dUpperBoundOccurrences;
        Time tDistance = this.tStep.multiply(scale);
        if (tDistance == null) {
            return null;
        }
        return AmaltheaServices.adjustTimeUnit(tDistance);
    }

    @Override
    public Time deltaMinus(long n) {
        if (n < 2L) {
            return null;
        }
        double scale = (double)(n - 1L) / this.dLowerBoundOccurrences;
        Time tDistance = this.tStep.multiply(scale);
        if (tDistance == null) {
            return null;
        }
        return AmaltheaServices.adjustTimeUnit(tDistance);
    }

    @Override
    public double getUtilization(Process process, RuntimeUtil.TimeType tt, EMap<ModeLabel, String> modes) {
        Time executionTime = RuntimeUtil.getExecutionTimeForProcess(process, modes, tt);
        if (tt.equals((Object)RuntimeUtil.TimeType.BCET)) {
            return executionTime.multiply(this.dLowerBoundOccurrences).divide(this.getStep());
        }
        if (tt.equals((Object)RuntimeUtil.TimeType.WCET)) {
            return executionTime.multiply(this.dUpperBoundOccurrences).divide(this.getStep());
        }
        if (tt.equals((Object)RuntimeUtil.TimeType.ACET)) {
            return executionTime.multiply(this.dAverageBoundOccurrences).divide(this.getStep());
        }
        return -1.0;
    }

    public Time getStep() {
        return this.tStep;
    }

    public void setStep(Time step) {
        this.tStep = step;
    }

    public double getLowerBoundOccurrences() {
        return this.dLowerBoundOccurrences;
    }

    public void setLowerBoundOccurrences(double dLowerBoundOccurrences) {
        this.dLowerBoundOccurrences = dLowerBoundOccurrences;
    }

    public double getAverageBoundOccurrences() {
        return this.dAverageBoundOccurrences;
    }

    public void setAverageBoundOccurrences(double dAverageBoundOccurrences) {
        this.dAverageBoundOccurrences = dAverageBoundOccurrences;
    }

    public double getUpperBoundOccurrences() {
        return this.dUpperBoundOccurrences;
    }

    public void setUpperBoundOccurrences(double dUpperBoundOccurrences) {
        this.dUpperBoundOccurrences = dUpperBoundOccurrences;
    }
}

