/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaCrossReferenceAdapter;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class AmaltheaIndex {
    private static final String ARG_OBJECT_MESSAGE = "Object argument is null, expected: EObject";
    private static final String ARG_COLLECTION_MESSAGE = "Collection argument is null,  expected: Collection<? extends EObject>";
    private static final String ARG_NOTIFIER_MESSAGE = "Context argument is null, expected: Notifier";
    private static final String ARG_STREAM_MESSAGE = "Stream argument is null, expected: PrintStream";
    private static final String ARG_NAME_MESSAGE = "Name argument is null, expected: String";
    private static final String ARG_PATTERN_MESSAGE = "Pattern argument is null, expected: Pattern";
    private static final String ARG_CLASS_MESSAGE = "Class argument is null, expected: Class<T extends INamed>";
    private static final String ARG_RESULT_REFERENCE_MESSAGE = "Result reference argument is null, expected: EReference";
    private static final String ARG_TARGET_REFERENCES_MESSAGE = "Target references argument is null, expected: Set<EReference>";
    private static final String ARG_TARGET_REFERENCE_MESSAGE = "Target reference argument is null, expected: EReference";

    private AmaltheaIndex() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> EList<T> getInverseReferences(@NonNull EObject eObject, @NonNull EReference resultEReference, @NonNull Set<@NonNull EReference> targetEReferences) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        Preconditions.checkArgument((resultEReference != null ? 1 : 0) != 0, (Object)ARG_RESULT_REFERENCE_MESSAGE);
        Preconditions.checkArgument((targetEReferences != null ? 1 : 0) != 0, (Object)ARG_TARGET_REFERENCES_MESSAGE);
        AmaltheaCrossReferenceAdapter amaltheaAdapter = AmaltheaIndex.getOrCreateAmaltheaAdapter((Notifier)eObject);
        ArrayList<EObject> result = new ArrayList<EObject>();
        Collection nonNavigableInverseReferences = amaltheaAdapter.getNonNavigableInverseReferences(eObject);
        for (EStructuralFeature.Setting setting : nonNavigableInverseReferences) {
            if (!targetEReferences.contains(setting.getEStructuralFeature())) continue;
            EObject targetEObject = setting.getEObject();
            result.add(targetEObject);
        }
        int size = result.size();
        Object[] values = result.toArray();
        return new EcoreEList.UnmodifiableEList((InternalEObject)eObject, (EStructuralFeature)resultEReference, size, values);
    }

    public static Set<EObject> getReferringObjects(@NonNull EObject eObject) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        return AmaltheaIndex.getOrCreateAmaltheaAdapter((Notifier)eObject).getNonNavigableInverseReferences(eObject).stream().map(EStructuralFeature.Setting::getEObject).collect(Collectors.toSet());
    }

    public static <T extends EObject> Set<T> getReferringObjects(@NonNull EObject eObject, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        return AmaltheaIndex.getOrCreateAmaltheaAdapter((Notifier)eObject).getNonNavigableInverseReferences(eObject).stream().map(EStructuralFeature.Setting::getEObject).filter(targetClass::isInstance).map(targetClass::cast).collect(Collectors.toSet());
    }

    public static <T extends EObject> Set<T> getReferringObjects(@NonNull EObject eObject, @NonNull Class<T> targetClass, @NonNull EReference targetEReference) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        Preconditions.checkArgument((targetEReference != null ? 1 : 0) != 0, (Object)ARG_TARGET_REFERENCE_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        return AmaltheaIndex.getOrCreateAmaltheaAdapter((Notifier)eObject).getNonNavigableInverseReferences(eObject).stream().filter(setting -> setting.getEStructuralFeature() == targetEReference).map(EStructuralFeature.Setting::getEObject).filter(targetClass::isInstance).map(targetClass::cast).collect(Collectors.toSet());
    }

    public static IReferable getEObjectByID(@NonNull Notifier context, @Nullable String id) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        if (id == null || id.isEmpty()) {
            return null;
        }
        int beginIndex = id.contains("/") ? id.lastIndexOf(47) + 1 : 0;
        int endIndex = id.indexOf("?type=");
        if (endIndex > beginIndex) {
            String name = id.substring(beginIndex, endIndex);
            if (name.equals("no-name")) {
                name = "";
            }
            for (IReferable elem : AmaltheaIndex.getElements(context, name, IReferable.class)) {
                if (!id.endsWith(elem.eClass().getName()) || !id.equals(elem.getUniqueName())) continue;
                return elem;
            }
        }
        return null;
    }

    public static List<Set<IReferable>> getObjectsWithConflictingNames(@NonNull Notifier context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        @NonNull List<@NonNull Set<@NonNull IReferable>> list = AmaltheaIndex.getOrCreateAmaltheaAdapter(context).getObjectsWithConflictingNames();
        ArrayList<Set<IReferable>> result = new ArrayList<Set<IReferable>>();
        for (Set<IReferable> initialSet : list) {
            Set<IReferable> filteredSet = AmaltheaIndex.filterElements(context, initialSet);
            if (filteredSet.size() <= 1) continue;
            result.add(filteredSet);
        }
        return result;
    }

    public static void buildIndex(@NonNull Notifier context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        AmaltheaIndex.getOrCreateAmaltheaAdapter(context);
    }

    public static void delete(@NonNull EObject eObject) {
        Preconditions.checkArgument((eObject != null ? 1 : 0) != 0, (Object)ARG_OBJECT_MESSAGE);
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(eObject);
        AmaltheaIndex.deleteAll(list, true);
    }

    public static void deleteAll(@NonNull Collection<? extends EObject> eObjects) {
        Preconditions.checkArgument((eObjects != null ? 1 : 0) != 0, (Object)ARG_COLLECTION_MESSAGE);
        AmaltheaIndex.deleteAll(eObjects, true);
    }

    public static void deleteAll(@NonNull Collection<? extends EObject> eObjects, boolean recursive) {
        Preconditions.checkArgument((eObjects != null ? 1 : 0) != 0, (Object)ARG_COLLECTION_MESSAGE);
        Set<@NonNull T> objectsToDelete = eObjects.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Notifier commonContext = AmaltheaIndex.ensureCommonContext(objectsToDelete);
        if (commonContext == null) {
            return;
        }
        HashSet<Object> eAllObjects = new HashSet<Object>();
        if (recursive) {
            for (EObject eObject : objectsToDelete) {
                TreeIterator j = eObject.eAllContents();
                while (j.hasNext()) {
                    InternalEObject childEObject = (InternalEObject)j.next();
                    eAllObjects.add(childEObject);
                }
            }
        }
        eAllObjects.addAll(objectsToDelete);
        AmaltheaCrossReferenceAdapter amaltheaAdapter = AmaltheaIndex.getOrCreateAmaltheaAdapter(commonContext);
        for (EObject eObject : eAllObjects) {
            Collection inverseReferences = amaltheaAdapter.getInverseReferences(eObject);
            for (EStructuralFeature.Setting settingObject : inverseReferences) {
                if (!settingObject.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)settingObject, (Object)eObject);
            }
            EcoreUtil.remove((EObject)eObject);
        }
    }

    private static Notifier ensureCommonContext(Set<@NonNull ? extends EObject> objectsToDelete) {
        Notifier commonContext = null;
        for (EObject eObject : objectsToDelete) {
            Notifier context = AmaltheaIndex.getRootContext(eObject);
            if (commonContext == null) {
                commonContext = context;
                continue;
            }
            if (commonContext == context) continue;
            throw new IllegalArgumentException("Objects don't share a common context");
        }
        return commonContext;
    }

    public static <T extends INamed> Set<T> getElements(@NonNull Notifier context, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        @NonNull Set<@NonNull T> elements = AmaltheaIndex.getOrCreateAmaltheaAdapter(context).getElements(targetClass);
        return AmaltheaIndex.filterElements(context, elements);
    }

    public static <T extends INamed> Set<T> getElements(@NonNull Notifier context, @NonNull String name, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)ARG_NAME_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        @NonNull Set<@NonNull T> elements = AmaltheaIndex.getOrCreateAmaltheaAdapter(context).getElements(name, targetClass);
        return AmaltheaIndex.filterElements(context, elements);
    }

    public static <T extends INamed> Set<T> getElements(@NonNull Notifier context, @NonNull Pattern namePattern, @NonNull Class<T> targetClass) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((namePattern != null ? 1 : 0) != 0, (Object)ARG_PATTERN_MESSAGE);
        Preconditions.checkArgument((targetClass != null ? 1 : 0) != 0, (Object)ARG_CLASS_MESSAGE);
        @NonNull Set<@NonNull T> elements = AmaltheaIndex.getOrCreateAmaltheaAdapter(context).getElements(namePattern, targetClass);
        return AmaltheaIndex.filterElements(context, elements);
    }

    public static void dumpAdapterInfo(@NonNull Notifier context, int info, @NonNull PrintStream stream) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)ARG_NOTIFIER_MESSAGE);
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)ARG_STREAM_MESSAGE);
        AmaltheaCrossReferenceAdapter adapter = AmaltheaIndex.getOrCreateAmaltheaAdapter(context);
        switch (info) {
            case 1: {
                adapter.dumpInfo(stream);
                break;
            }
            case 2: {
                adapter.dumpCrossReferenceMap(stream);
                break;
            }
            case 3: {
                adapter.dumpNameIndex(stream);
                break;
            }
            default: {
                stream.append("undefined info selector: " + info);
            }
        }
    }

    private static synchronized @NonNull AmaltheaCrossReferenceAdapter getOrCreateAmaltheaAdapter(@NonNull Notifier target) {
        EList adapters = AmaltheaIndex.getRootContext(target).eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof AmaltheaCrossReferenceAdapter)) continue;
            return (AmaltheaCrossReferenceAdapter)adapter;
        }
        AmaltheaCrossReferenceAdapter amaltheaAdapter = new AmaltheaCrossReferenceAdapter();
        adapters.add((Object)amaltheaAdapter);
        return amaltheaAdapter;
    }

    private static @NonNull Notifier getRootContext(@NonNull EObject eObject) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
        Resource resource = rootContainer.eResource();
        if (resource != null) {
            return AmaltheaIndex.getRootContext(resource);
        }
        return rootContainer;
    }

    private static @NonNull Notifier getRootContext(@NonNull Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet != null) {
            return resourceSet;
        }
        return resource;
    }

    private static @NonNull Notifier getRootContext(@NonNull Notifier notifier) {
        if (notifier instanceof EObject) {
            return AmaltheaIndex.getRootContext((EObject)notifier);
        }
        if (notifier instanceof Resource) {
            return AmaltheaIndex.getRootContext((Resource)notifier);
        }
        return notifier;
    }

    private static Resource getResource(Notifier notifier) {
        if (notifier instanceof EObject) {
            return ((EObject)notifier).eResource();
        }
        if (notifier instanceof Resource) {
            return (Resource)notifier;
        }
        return null;
    }

    private static <T extends INamed> Set<T> filterElements(@NonNull Notifier context, Set<@NonNull T> elements) {
        Notifier rootContext = AmaltheaIndex.getRootContext(context);
        Resource resource = AmaltheaIndex.getResource(context);
        if (rootContext instanceof ResourceSet && resource != null) {
            URI folderUri = resource.getURI().trimSegments(1);
            return elements.stream().filter(e -> e.eResource().getURI().trimSegments(1).equals(folderUri)).collect(Collectors.toSet());
        }
        return elements;
    }
}

