/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.service.processing;

import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.editor.contribution.service.ProcessingService;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.service.component.annotations.Component;

@Component(property={"name = Cleanup | Remove invalid DataSize objects", "description = Remove DataSize objects with value <= 0 or missing unit"})
public class CleanupDataSize
implements ProcessingService {
    @PostConstruct
    public String cleanup(Amalthea model) {
        HashSet<DataSize> toDelete = new HashSet<DataSize>();
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)model, (boolean)false);
        while (iterator.hasNext()) {
            DataSize size;
            EObject next = (EObject)iterator.next();
            if (!(next instanceof DataSize) || (size = (DataSize)next).getValue().signum() >= 1 && size.getUnit() != DataSizeUnit._UNDEFINED_) continue;
            toDelete.add(size);
        }
        EcoreUtil.removeAll(toDelete);
        return "Deleted " + toDelete.size() + " invalid DataSize objects.";
    }
}

