/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DateFormatType implements Enumerator
{
    LONG_LITERAL(0, "Long", "Long"),
    SHORT_LITERAL(1, "Short", "Short"),
    MEDIUM_LITERAL(2, "Medium", "Medium"),
    FULL_LITERAL(3, "Full", "Full");

    public static final int LONG = 0;
    public static final int SHORT = 1;
    public static final int MEDIUM = 2;
    public static final int FULL = 3;
    private static final DateFormatType[] VALUES_ARRAY;
    public static final List<DateFormatType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DateFormatType[]{LONG_LITERAL, SHORT_LITERAL, MEDIUM_LITERAL, FULL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DateFormatType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateFormatType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateFormatType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DateFormatType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DateFormatType get(int value) {
        switch (value) {
            case 0: {
                return LONG_LITERAL;
            }
            case 1: {
                return SHORT_LITERAL;
            }
            case 2: {
                return MEDIUM_LITERAL;
            }
            case 3: {
                return FULL_LITERAL;
            }
        }
        return null;
    }

    private DateFormatType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

