/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometryext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointList3D
extends PointList
implements List<IVector3f> {
    private static final long serialVersionUID = -8955686832232579183L;
    List<Vector3fImpl> points3D;
    private float defaultZ = 0.0f;

    public PointList3D() {
        this(2);
    }

    public PointList3D(int[] points) {
        this(points.length);
        int i = 0;
        while (i < points.length) {
            this.addPoint(points[i], points[i + 1]);
            i += 2;
        }
    }

    public PointList3D(int initalCapacity) {
        this.points3D = new ArrayList<Vector3fImpl>(initalCapacity);
    }

    protected PointList3D(boolean do_not_create_list) {
        this.points3D = !do_not_create_list ? new ArrayList<Vector3fImpl>(2) : null;
    }

    public PointList3D(PointList3D i_pointList3D) {
        this(i_pointList3D.size());
        for (Vector3fImpl v : i_pointList3D.points3D) {
            this.points3D.add(new Vector3fImpl(v));
        }
    }

    public PointList3D(List<IVector3f> list) {
        this(list.size());
        for (IVector3f v : list) {
            this.points3D.add(new Vector3fImpl(v));
        }
    }

    public float getDefaultZ() {
        return this.defaultZ;
    }

    public void addPointByRef(Vector3fImpl v) {
        this.points3D.add(v);
    }

    public IVector3f getPoint3D(int index) {
        return (IVector3f)this.points3D.get(index);
    }

    public IVector3f getMidpoint3D() {
        if (this.size() % 2 == 0) {
            if (this.size() == 0) {
                return IVector3f.NULLVEC3f;
            }
            IVector3f v0 = this.getPoint3D(this.size() / 2 - 1);
            IVector3f v1 = this.getPoint3D(this.size() / 2);
            Vector3fImpl v = new Vector3fImpl();
            Math3D.add((IVector3f)v0, (IVector3f)v1, (Vector3f)v);
            Math3D.scale((float)0.5f, (IVector3f)v, (Vector3f)v);
            return v;
        }
        return this.getPoint3D(this.size() / 2);
    }

    protected Vector3fImpl toVector3f(Point i_p) {
        return new Vector3fImpl((float)i_p.x, (float)i_p.y, this.getDefaultZ());
    }

    protected Vector3fImpl toVector3f(int x, int y) {
        return new Vector3fImpl((float)x, (float)y, this.getDefaultZ());
    }

    protected Point toPoint(IVector3f v) {
        return new Point((int)v.getX(), (int)v.getY());
    }

    protected void toPoint(IVector3f v, Point intoPoint) {
        intoPoint.x = (int)v.getX();
        intoPoint.y = (int)v.getY();
    }

    public void set(List<? extends IVector3f> i_points) {
        this.points3D = new ArrayList<Vector3fImpl>(i_points.size());
        for (IVector3f iVector3f : i_points) {
            this.points3D.add(new Vector3fImpl(iVector3f));
        }
    }

    public void addAll(PointList source) {
        if (source instanceof PointList3D) {
            this.addAll((Collection)source);
        }
        int i = 0;
        while (i < source.size()) {
            this.addPoint(source.getPoint(i));
            ++i;
        }
    }

    public void addPoint(Point p) {
        this.addPointByRef(this.toVector3f(p));
    }

    public void addPoint(int x, int y) {
        this.addPointByRef(this.toVector3f(x, y));
    }

    public Rectangle getBounds() {
        if (this.size() == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        for (Vector3fImpl v : this.points3D) {
            if (v.x < minX) {
                minX = v.getX();
            }
            if (v.x > maxX) {
                maxX = v.getX();
            }
            if (v.y < minY) {
                minY = v.getY();
            }
            if (!(v.y > maxY)) continue;
            maxY = v.getY();
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    public PointList getCopy() {
        return new PointList3D(this);
    }

    public Point getFirstPoint() {
        return this.getPoint(0);
    }

    public IVector3f getFirstPoint3D() {
        return this.getPoint3D(0);
    }

    public Point getLastPoint() {
        return this.getPoint(this.size() - 1);
    }

    public IVector3f getLastPoint3D() {
        return this.getPoint3D(this.size() - 1);
    }

    public Point getMidpoint() {
        return this.toPoint(this.getMidpoint3D());
    }

    public Point getPoint(int index) {
        return this.toPoint(this.getPoint3D(index));
    }

    public Point getPoint(Point p, int index) {
        this.toPoint(this.getPoint3D(index), p);
        return p;
    }

    public void insertPoint(Point p, int index) {
        this.points3D.add(index, this.toVector3f(p));
    }

    public boolean intersects(Rectangle r) {
        Rectangle rect = this.getBounds();
        return rect.intersects(r);
    }

    public void performScale(double factor) {
        for (Vector3fImpl v : this.points3D) {
            Math3D.scale((float)((float)factor), (IVector3f)v, (Vector3f)v);
        }
    }

    public void performTranslate(int dx, int dy) {
        for (Vector3fImpl v : this.points3D) {
            Math3D.translate((IVector3f)v, (float)dx, (float)dy, (float)0.0f, (Vector3f)v);
        }
    }

    public void removeAllPoints() {
        this.points3D.clear();
    }

    public Point removePoint(int index) {
        return this.toPoint((IVector3f)this.points3D.remove(index));
    }

    public void reverse() {
        Collections.reverse(this.points3D);
    }

    public void setPoint(Point pt, int index) {
        this.points3D.set(index, this.toVector3f(pt));
    }

    public void setSize(int newSize) {
        if (this.size() >= newSize) {
            int i = this.size() - 1;
            while (i >= newSize) {
                this.points3D.remove(i);
                --i;
            }
        } else {
            int i = this.size();
            while (i < newSize) {
                this.points3D.add(new Vector3fImpl());
                ++i;
            }
        }
    }

    @Override
    public int size() {
        return this.points3D.size();
    }

    public int[] toIntArray() {
        int[] aint = new int[this.size() * 2];
        int i = 0;
        for (Vector3fImpl v : this.points3D) {
            aint[i++] = (int)v.x;
            aint[i++] = (int)v.y;
        }
        return aint;
    }

    public void translate(int x, int y) {
        this.performTranslate(x, y);
    }

    public void transpose() {
        for (Vector3fImpl v : this.points3D) {
            float t = v.x;
            v.x = v.y;
            v.y = t;
        }
    }

    @Override
    public boolean add(IVector3f v) {
        return this.points3D.add(new Vector3fImpl(v));
    }

    @Override
    public IVector3f remove(int index) {
        return (IVector3f)this.points3D.remove(index);
    }

    @Override
    public IVector3f set(int index, IVector3f v) {
        return (IVector3f)this.points3D.set(index, new Vector3fImpl(v));
    }

    @Override
    public IVector3f get(int index) {
        return (IVector3f)this.points3D.get(index);
    }

    @Override
    public void clear() {
        this.removeAllPoints();
    }

    @Override
    public void add(int index, IVector3f v) {
        this.points3D.add(index, new Vector3fImpl(v));
    }

    @Override
    public boolean addAll(Collection<? extends IVector3f> vectors) {
        ArrayList<Vector3fImpl> vimpls = new ArrayList<Vector3fImpl>(vectors.size());
        for (IVector3f iVector3f : vectors) {
            vimpls.add(new Vector3fImpl(iVector3f));
        }
        return this.points3D.addAll(vimpls);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IVector3f> vectors) {
        ArrayList<Vector3fImpl> vimpls = new ArrayList<Vector3fImpl>(vectors.size());
        for (IVector3f iVector3f : vectors) {
            vimpls.add(new Vector3fImpl(iVector3f));
        }
        return this.points3D.addAll(index, vimpls);
    }

    @Override
    public boolean contains(Object i_o) {
        if (i_o instanceof Point) {
            return this.indexOf(i_o) >= 0;
        }
        return this.points3D.contains(i_o);
    }

    @Override
    public boolean containsAll(Collection<?> i_c) {
        return this.points3D.containsAll(i_c);
    }

    @Override
    public int indexOf(Object i_o) {
        if (i_o instanceof Point) {
            Point p = (Point)i_o;
            int i = 0;
            for (Vector3fImpl v : this.points3D) {
                if ((int)v.x == p.x && (int)v.y == p.y) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        return this.points3D.indexOf(i_o);
    }

    @Override
    public boolean isEmpty() {
        return this.points3D.isEmpty();
    }

    @Override
    public int lastIndexOf(Object i_o) {
        return this.points3D.lastIndexOf(i_o);
    }

    @Override
    public ListIterator<IVector3f> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public Iterator<IVector3f> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<IVector3f> listIterator(int index) {
        return new PointList3DIterator(index);
    }

    @Override
    public List<IVector3f> subList(int fromIndex, int toIndex) {
        ArrayList<IVector3f> sub = new ArrayList<IVector3f>(toIndex - fromIndex);
        int i = fromIndex;
        while (i < toIndex) {
            sub.add((IVector3f)this.points3D.get(i));
            ++i;
        }
        return sub;
    }

    @Override
    public boolean remove(Object o) {
        return this.points3D.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> i_c) {
        return this.points3D.removeAll(i_c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.points3D.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.points3D.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.points3D.toArray(a);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder(this.getClass().getSimpleName());
        strb.append(": {");
        boolean bFirst = true;
        for (Vector3fImpl v : this.points3D) {
            if (!bFirst) {
                strb.append(", ");
            } else {
                bFirst = false;
            }
            strb.append(v.toString());
        }
        strb.append("}");
        return strb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointList3DIterator
    implements ListIterator<IVector3f> {
        int pos = 0;

        public PointList3DIterator(int start) {
            this.pos = start;
        }

        @Override
        public void add(IVector3f v) {
            PointList3D.this.add(this.pos, v);
        }

        @Override
        public boolean hasNext() {
            return this.pos < PointList3D.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public IVector3f next() {
            if (this.pos >= PointList3D.this.size()) {
                throw new NoSuchElementException();
            }
            return PointList3D.this.get(this.pos++);
        }

        @Override
        public int nextIndex() {
            return this.pos;
        }

        @Override
        public IVector3f previous() {
            if (this.pos == 0 || PointList3D.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            return PointList3D.this.get(--this.pos);
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void remove() {
            PointList3D.this.remove(this.pos);
        }

        @Override
        public void set(IVector3f v) {
            PointList3D.this.set(this.pos, v);
        }
    }
}

