/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.IFigure2DHost3D;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.util.Draw3DCache;

public class XYZLayout
extends XYLayout {
    private static final Logger log = Logger.getLogger(XYZLayout.class.getName());

    public void layout(IFigure parent) {
        Point offset = this.getOrigin(parent);
        ISurface surface = null;
        if (parent instanceof IFigure2DHost3D) {
            surface = ((IFigure2DHost3D)parent).getSurface();
        }
        for (Object child : parent.getChildren()) {
            IFigure f = (IFigure)child;
            Object constraint = this.getConstraint(f);
            if (constraint == null) continue;
            this.layoutChild(f, constraint, offset, surface);
        }
    }

    protected void layoutChild(IFigure f, Object i_constraint, Point offset, ISurface surface) {
        Object processedConstraint = i_constraint;
        if (processedConstraint instanceof IPosition3D) {
            if (f instanceof IFigure3D) {
                ((IFigure3D)f).getPosition3D().setPosition((IPosition3D)processedConstraint);
                return;
            }
            processedConstraint = this.toRectangle(((IPosition3D)processedConstraint).getBounds3D(), surface);
        } else if (processedConstraint instanceof IBoundingBox) {
            if (f instanceof IFigure3D) {
                Vector3f location = Draw3DCache.getVector3f();
                Vector3f size = Draw3DCache.getVector3f();
                try {
                    IBoundingBox boundingBox = (IBoundingBox)processedConstraint;
                    boundingBox.getLocation(location);
                    boundingBox.getSize(size);
                    ((IFigure3D)f).getPosition3D().setLocation3D((IVector3f)location);
                    ((IFigure3D)f).getPosition3D().setSize3D((IVector3f)size);
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                    throw throwable;
                }
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                return;
            }
            processedConstraint = this.toRectangle((IBoundingBox)processedConstraint, surface);
        } else if (processedConstraint instanceof IVector3f) {
            if (f instanceof IFigure3D) {
                ((IFigure3D)f).getPosition3D().setLocation3D((IVector3f)processedConstraint);
                return;
            }
            processedConstraint = this.toRectangle((IVector3f)processedConstraint, surface);
        }
        if (processedConstraint instanceof Rectangle) {
            Rectangle bounds = (Rectangle)processedConstraint;
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension figuresPreferredSize = f.getPreferredSize(bounds.width, bounds.height);
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = figuresPreferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = figuresPreferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            f.setBounds(bounds);
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Cannot handle constraint type " + processedConstraint.getClass() + " for " + f.getClass());
        }
    }

    protected Rectangle toRectangle(IBoundingBox boundingBox, ISurface surface) {
        Rectangle rectangle;
        if (surface == null) {
            Rectangle rectangle2;
            Vector3f location = Draw3DCache.getVector3f();
            boundingBox.getLocation(location);
            Vector3f size = Draw3DCache.getVector3f();
            boundingBox.getSize(size);
            try {
                rectangle2 = new Rectangle((int)location.getX(), (int)location.getY(), (int)size.getX(), (int)size.getY());
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            return rectangle2;
        }
        Point l2D = Draw3DCache.getPoint();
        Point e2D = Draw3DCache.getPoint();
        Vector3f location = Draw3DCache.getVector3f();
        boundingBox.getLocation(location);
        Vector3f end = Draw3DCache.getVector3f();
        boundingBox.getEnd(end);
        try {
            surface.getSurfaceLocation2D((IVector3f)location, l2D);
            surface.getSurfaceLocation2D((IVector3f)end, e2D);
            rectangle = new Rectangle(l2D, e2D);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPoint(l2D, e2D);
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, end});
            throw throwable;
        }
        Draw3DCache.returnPoint(l2D, e2D);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, end});
        return rectangle;
    }

    protected Rectangle toRectangle(IVector3f location3D, ISurface surface) {
        if (surface == null) {
            return new Rectangle((int)location3D.getX(), (int)location3D.getY(), -1, -1);
        }
        Point p = surface.getSurfaceLocation2D(location3D, null);
        return new Rectangle(p.x, p.y, -1, -1);
    }
}

