/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IEPackageProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EPackageProvider
implements IEPackageProvider {
    private Map<String, Set<EPackage>> ePackages = new LinkedHashMap<String, Set<EPackage>>();
    private final Map<Class<?>, Set<EClassifier>> class2classifiers = new HashMap();
    private final Map<String, Set<EClassifier>> className2classifiers = new HashMap<String, Set<EClassifier>>();
    private final Map<EClassifier, Class<?>> classifier2class = new HashMap();
    private final Map<EClass, Set<EStructuralFeature>> containingFeaturesForOneClassHierarchy = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> containingFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> allContainingFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EStructuralFeature>> inverseFeatures = new HashMap<EClass, Set<EStructuralFeature>>();
    private final Map<EClass, Set<EClass>> subTypes = new HashMap<EClass, Set<EClass>>();

    @Override
    public Set<EPackage> getEPackage(String name) {
        LinkedHashSet<EPackage> res = new LinkedHashSet<EPackage>();
        Set<EPackage> set = this.ePackages.get(name);
        if (set != null) {
            res.addAll(set);
        }
        return res;
    }

    public Collection<EPackage> removePackage(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        Set<EPackage> set = this.ePackages.get(ePackage.getName());
        if (set != null && set.remove(ePackage)) {
            if (set.isEmpty()) {
                this.ePackages.remove(ePackage.getName());
            }
            result.add(ePackage);
            for (EClassifier eCls : ePackage.getEClassifiers()) {
                this.removeEClassifierClass(eCls);
                if (!(eCls instanceof EClass)) continue;
                this.removeFeatures((EClass)eCls);
                this.removeSubType((EClass)eCls);
            }
            for (EPackage childPkg : ePackage.getESubpackages()) {
                this.removePackage(childPkg);
            }
            this.containingFeatures.clear();
            this.allContainingFeatures.clear();
        }
        return result;
    }

    private void removeSubType(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null || !types.remove(eCls) || types.size() != 0) continue;
            types = new LinkedHashSet<EClass>();
            this.subTypes.remove(superECls);
        }
    }

    private void removeFeatures(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            Set<EStructuralFeature> possibleContainementFeatures;
            if (!(feature.getEType() instanceof EClass)) continue;
            Set<EStructuralFeature> possibleInverseFeatures = this.inverseFeatures.get(feature.getEType());
            if (possibleInverseFeatures != null && possibleInverseFeatures.remove(feature) && possibleInverseFeatures.size() == 0) {
                this.inverseFeatures.remove(feature.getEType());
            }
            if (!this.isContainingEStructuralFeature(feature) || (possibleContainementFeatures = this.containingFeaturesForOneClassHierarchy.get(feature.getEType())) == null || !possibleContainementFeatures.remove(feature) || possibleContainementFeatures.size() != 0) continue;
            this.containingFeaturesForOneClassHierarchy.remove(feature.getEType());
        }
    }

    private boolean isContainingEStructuralFeature(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isContainment() || feature instanceof EAttribute;
    }

    private void removeEClassifierClass(EClassifier eCls) {
        String qualifiedName;
        Set<EClassifier> classifiersFromClassName;
        Class<?> instanceClass = this.getClass(eCls);
        Set<EClassifier> classifiersFromClass = this.class2classifiers.get(instanceClass);
        if (classifiersFromClass != null) {
            if (classifiersFromClass.size() == 1) {
                this.class2classifiers.remove(instanceClass);
            } else {
                classifiersFromClass.remove(eCls);
            }
        }
        if (instanceClass != null && (classifiersFromClassName = this.className2classifiers.get(qualifiedName = instanceClass.getCanonicalName())) != null) {
            if (classifiersFromClassName.size() == 1) {
                this.className2classifiers.remove(qualifiedName);
            } else {
                classifiersFromClassName.remove(eCls);
            }
        }
        this.classifier2class.remove(eCls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EPackage registerPackage(EPackage ePackage) {
        boolean increasedSize;
        if ("ecore".equals(ePackage.getName())) {
            if (!"http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI())) return null;
        }
        if (ePackage.getName() == null) throw new IllegalStateException("Couldn't register package " + ePackage.getName() + " because its name is null.");
        Set<EPackage> set = this.ePackages.get(ePackage.getName());
        if (set == null) {
            set = new LinkedHashSet<EPackage>();
            this.ePackages.put(ePackage.getName(), set);
        }
        if (!(increasedSize = set.add(ePackage))) {
            return null;
        }
        EPackage result = ePackage;
        for (EClassifier eCls : ePackage.getEClassifiers()) {
            this.registerEClassifierClass(eCls);
            if (!(eCls instanceof EClass)) continue;
            this.registerFeatures((EClass)eCls);
            this.registerSubTypes((EClass)eCls);
        }
        for (EPackage childPkg : ePackage.getESubpackages()) {
            this.registerPackage(childPkg);
        }
        this.containingFeatures.clear();
        this.allContainingFeatures.clear();
        return result;
    }

    private void registerSubTypes(EClass eCls) {
        for (EClass superECls : eCls.getESuperTypes()) {
            Set<EClass> types = this.subTypes.get(superECls);
            if (types == null) {
                types = new LinkedHashSet<EClass>();
                this.subTypes.put(superECls, types);
            }
            types.add(eCls);
        }
    }

    private void registerFeatures(EClass eCls) {
        for (EStructuralFeature feature : eCls.getEStructuralFeatures()) {
            if (!(feature.getEType() instanceof EClass)) continue;
            Set<EStructuralFeature> possibleInverseFeatures = this.inverseFeatures.get(feature.getEType());
            if (possibleInverseFeatures == null) {
                possibleInverseFeatures = new LinkedHashSet<EStructuralFeature>();
                this.inverseFeatures.put((EClass)feature.getEType(), possibleInverseFeatures);
            }
            possibleInverseFeatures.add(feature);
            if (!this.isContainingEStructuralFeature(feature)) continue;
            Set<EStructuralFeature> possibleContainementFeatures = this.containingFeaturesForOneClassHierarchy.get(feature.getEType());
            if (possibleContainementFeatures == null) {
                possibleContainementFeatures = new LinkedHashSet<EStructuralFeature>();
                this.containingFeaturesForOneClassHierarchy.put((EClass)feature.getEType(), possibleContainementFeatures);
            }
            possibleContainementFeatures.add(feature);
        }
    }

    private void registerEClassifierClass(EClassifier eCls) {
        Class instanceClass;
        Class customClass = this.classifier2class.get(eCls);
        if (customClass != null) {
            instanceClass = customClass;
        } else {
            instanceClass = eCls.getInstanceClass();
            this.classifier2class.put(eCls, instanceClass);
        }
        Set<EClassifier> classifiersFromClass = this.class2classifiers.get(instanceClass);
        if (classifiersFromClass == null) {
            classifiersFromClass = new LinkedHashSet<EClassifier>();
            this.class2classifiers.put(instanceClass, classifiersFromClass);
        }
        classifiersFromClass.add(eCls);
        if (instanceClass != null) {
            String qualifiedName = instanceClass.getCanonicalName();
            Set<EClassifier> classifiersFromClassName = this.className2classifiers.get(qualifiedName);
            if (classifiersFromClassName == null) {
                classifiersFromClassName = new LinkedHashSet<EClassifier>();
                this.className2classifiers.put(qualifiedName, classifiersFromClassName);
            }
            classifiersFromClassName.add(eCls);
        }
    }

    @Override
    public Set<EClassifier> getTypes(String name, String classifierName) {
        LinkedHashSet<EClassifier> classifiers = new LinkedHashSet<EClassifier>();
        Set<EPackage> set = this.ePackages.get(name);
        if (set != null) {
            for (EPackage ePackage : set) {
                EClassifier clazz = ePackage.getEClassifier(classifierName);
                if (clazz == null) continue;
                classifiers.add(clazz);
            }
        }
        return classifiers;
    }

    @Override
    public EClassifier getType(String name, String classifierName) {
        Set<EClassifier> result = this.getTypes(name, classifierName);
        if (result.size() == 0) {
            return null;
        }
        return (EClassifier)result.iterator().next();
    }

    public Set<EEnumLiteral> getEnumLiterals(String name, String enumName, String literalName) {
        LinkedHashSet<EEnumLiteral> result = new LinkedHashSet<EEnumLiteral>();
        Set<EPackage> set = this.ePackages.get(name);
        if (set != null) {
            for (EPackage ePackage : set) {
                EEnumLiteral literal;
                EClassifier eClassifier = ePackage.getEClassifier(enumName);
                if (eClassifier == null || (literal = this.getEnumLiteral(eClassifier, literalName)) == null) continue;
                result.add(literal);
            }
        }
        return result;
    }

    @Override
    public EClassifier getType(String classifierName) {
        EClassifier result = null;
        for (Set<EPackage> ePkgs : this.ePackages.values()) {
            for (EPackage ePackage : ePkgs) {
                EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
                if (foundClassifier == null) continue;
                if (result == null) {
                    result = foundClassifier;
                    continue;
                }
                String firstFullyQualifiedName = result.getEPackage().getName() + "." + result.getName();
                String secondFullyQualifiedName = foundClassifier.getEPackage().getName() + "." + foundClassifier.getName();
                String message = "Ambiguous classifier request. At least two classifiers matches %s : %s and %s";
                throw new IllegalStateException(String.format(message, classifierName, firstFullyQualifiedName, secondFullyQualifiedName));
            }
        }
        return result;
    }

    @Override
    public Set<EClassifier> getTypes(String classifierName) {
        LinkedHashSet<EClassifier> result = new LinkedHashSet<EClassifier>();
        for (Set<EPackage> ePkgs : this.ePackages.values()) {
            for (EPackage ePackage : ePkgs) {
                EClassifier foundClassifier = ePackage.getEClassifier(classifierName);
                if (foundClassifier == null) continue;
                result.add(foundClassifier);
            }
        }
        return result;
    }

    @Override
    public EEnumLiteral getEnumLiteral(String packageName, String enumName, String literalName) {
        Collection result = this.getEnumLiterals(packageName, enumName, literalName);
        if (result.size() == 0) {
            return null;
        }
        return (EEnumLiteral)result.iterator().next();
    }

    @Override
    public EEnumLiteral getEnumLiteral(String enumName, String literalName) {
        EClassifier eClassifier = this.getType(enumName);
        if (eClassifier == null) {
            return null;
        }
        return this.getEnumLiteral(eClassifier, literalName);
    }

    private EEnumLiteral getEnumLiteral(EClassifier eClassifier, String literalName) {
        EEnumLiteral result = eClassifier instanceof EEnum ? ((EEnum)eClassifier).getEEnumLiteral(literalName) : null;
        return result;
    }

    @Override
    public Set<EClassifier> getEClassifiers(Class<?> cls) {
        return this.class2classifiers.get(cls);
    }

    @Override
    public Set<EClassifier> getEClassifiers(String clsName) {
        return this.className2classifiers.get(clsName);
    }

    @Override
    public Class<?> getClass(EClassifier eCls) {
        return this.classifier2class.get(eCls);
    }

    @Override
    public boolean isRegistered(EClassifier eCls) {
        return this.classifier2class.containsKey(eCls);
    }

    public void registerCustomClassMapping(EClassifier eClassifier, Class<?> cls) {
        String qualifiedName;
        Set<EClassifier> eClassifiersFromClassName;
        Set<EClassifier> eClassifiersFromClass;
        Class<?> oldClass = this.classifier2class.remove(eClassifier);
        if (oldClass != null) {
            eClassifiersFromClass = this.class2classifiers.get(oldClass);
            if (eClassifiersFromClass.remove(eClassifier) && eClassifiersFromClass.isEmpty()) {
                this.class2classifiers.remove(oldClass);
            }
            if ((eClassifiersFromClassName = this.className2classifiers.get(qualifiedName = oldClass.getCanonicalName())).remove(eClassifier) && eClassifiersFromClassName.isEmpty()) {
                this.className2classifiers.remove(qualifiedName);
            }
        }
        this.classifier2class.put(eClassifier, cls);
        eClassifiersFromClass = this.class2classifiers.get(cls);
        if (eClassifiersFromClass == null) {
            eClassifiersFromClass = new LinkedHashSet<EClassifier>();
            this.class2classifiers.put(cls, eClassifiersFromClass);
        }
        eClassifiersFromClass.add(eClassifier);
        if (cls != null) {
            qualifiedName = cls.getCanonicalName();
            eClassifiersFromClassName = this.className2classifiers.get(qualifiedName);
            if (eClassifiersFromClassName == null) {
                eClassifiersFromClassName = new LinkedHashSet<EClassifier>();
                this.className2classifiers.put(qualifiedName, eClassifiersFromClassName);
            }
            eClassifiersFromClassName.add(eClassifier);
        }
    }

    @Override
    public Set<EStructuralFeature> getEStructuralFeatures(Set<EClass> receiverEClasses) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        for (EClass eCls : receiverEClasses) {
            if (!this.isRegistered((EClassifier)eCls)) continue;
            result.addAll((Collection<EStructuralFeature>)eCls.getEAllStructuralFeatures());
        }
        return result;
    }

    @Override
    public Set<EClassifier> getEClassifiers() {
        LinkedHashSet<EClassifier> result = new LinkedHashSet<EClassifier>();
        for (Set<EPackage> ePkgs : this.ePackages.values()) {
            for (EPackage ePkg : ePkgs) {
                result.addAll((Collection<EClassifier>)ePkg.getEClassifiers());
            }
        }
        return result;
    }

    @Override
    public Set<EEnumLiteral> getEEnumLiterals() {
        LinkedHashSet<EEnumLiteral> result = new LinkedHashSet<EEnumLiteral>();
        for (Set<EPackage> ePkgs : this.ePackages.values()) {
            for (EPackage ePkg : ePkgs) {
                for (EClassifier eClassifier : ePkg.getEClassifiers()) {
                    if (!(eClassifier instanceof EEnum)) continue;
                    result.addAll((Collection<EEnumLiteral>)((EEnum)eClassifier).getELiterals());
                }
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getContainingEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EStructuralFeature feature : this.getContainingEStructuralFeatures(eCls)) {
            result.add(feature.getEContainingClass());
        }
        return result;
    }

    @Override
    public Set<EClass> getAllContainingEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EStructuralFeature feature : this.getAllContainingEStructuralFeatures(eCls)) {
            result.add(feature.getEContainingClass());
        }
        return result;
    }

    @Override
    public Set<EStructuralFeature> getAllContainingEStructuralFeatures(EClass type) {
        Set<EStructuralFeature> result = this.allContainingFeatures.get(type);
        if (result == null) {
            result = new LinkedHashSet<EStructuralFeature>();
            this.allContainingFeatures.put(type, result);
            HashSet<EClass> knownECls = new HashSet<EClass>();
            LinkedHashSet<EStructuralFeature> previousAdded = new LinkedHashSet<EStructuralFeature>(this.getAllContainingEStructuralFeaturesInternal(type));
            result.addAll(previousAdded);
            while (!previousAdded.isEmpty()) {
                LinkedHashSet<EStructuralFeature> currentAdded = new LinkedHashSet<EStructuralFeature>();
                for (EStructuralFeature feature : previousAdded) {
                    EClass eContainingClass = feature.getEContainingClass();
                    if (knownECls.contains(eContainingClass)) continue;
                    for (EStructuralFeature parentFeature : this.getAllContainingEStructuralFeaturesInternal(eContainingClass)) {
                        if (!result.add(parentFeature)) continue;
                        knownECls.add(eContainingClass);
                        currentAdded.add(parentFeature);
                    }
                }
                previousAdded = currentAdded;
            }
        }
        return result;
    }

    private Set<EStructuralFeature> getAllContainingEStructuralFeaturesInternal(EClass eCls) {
        Set<EStructuralFeature> result = this.containingFeatures.get(eCls);
        if (result == null) {
            result = new LinkedHashSet<EStructuralFeature>();
            this.containingFeatures.put(eCls, result);
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(eCls));
            for (EClass superType : eCls.getEAllSuperTypes()) {
                result.addAll(this.getAllContainingEStructuralFeaturesInternal(superType));
            }
            for (EClass subType : this.getAllSubTypes(eCls)) {
                result.addAll(this.getAllContainingEStructuralFeaturesInternal(subType));
            }
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(EcorePackage.eINSTANCE.getEObject()));
        }
        return result;
    }

    @Override
    public Set<EStructuralFeature> getContainingEStructuralFeatures(EClass eCls) {
        Set<EStructuralFeature> result = this.containingFeatures.get(eCls);
        if (result == null) {
            result = new LinkedHashSet<EStructuralFeature>();
            this.containingFeatures.put(eCls, result);
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(eCls));
            for (EClass superType : eCls.getEAllSuperTypes()) {
                result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(superType));
            }
            for (EClass subType : this.getAllSubTypes(eCls)) {
                result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(subType));
            }
            result.addAll(this.getContainingEStructuralFeaturesForOneEClassHierarchyLevel(EcorePackage.eINSTANCE.getEObject()));
        }
        return result;
    }

    private Set<EStructuralFeature> getContainingEStructuralFeaturesForOneEClassHierarchyLevel(EClass eCls) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        Set<EStructuralFeature> features = this.containingFeaturesForOneClassHierarchy.get(eCls);
        if (features != null) {
            result.addAll(features);
        }
        return result;
    }

    @Override
    public Set<EClass> getAllSubTypes(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EClass> types = this.subTypes.get(eCls);
        if (types != null) {
            for (EClass type : types) {
                result.add(type);
                result.addAll(this.getAllSubTypes(type));
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getContainedEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (this.isRegistered((EClassifier)eCls)) {
            LinkedHashSet features = new LinkedHashSet(eCls.getEAllStructuralFeatures());
            for (EClass subECls : this.getAllSubTypes(eCls)) {
                features.addAll(subECls.getEStructuralFeatures());
            }
            for (EStructuralFeature feature : features) {
                if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
                result.add((EClass)feature.getEType());
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getAllContainedEClasses(EClass eCls) {
        Set<EClass> directlyContainedEClasses = this.getContainedEClasses(eCls);
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>(directlyContainedEClasses);
        LinkedHashSet<EClass> added = new LinkedHashSet<EClass>(directlyContainedEClasses);
        while (!added.isEmpty()) {
            LinkedHashSet<EClass> toDig = new LinkedHashSet<EClass>();
            for (EClass a : added) {
                for (EClass contained : this.getContainedEClasses(a)) {
                    if (!result.add(contained)) continue;
                    toDig.add(contained);
                }
            }
            added = toDig;
        }
        return result;
    }

    @Override
    public Set<EClass> getInverseEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(eCls));
        for (EClass superType : eCls.getEAllSuperTypes()) {
            result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(superType));
        }
        for (EClass subType : this.getAllSubTypes(eCls)) {
            result.addAll(this.getInverseClassesForOneEClassHierarchyLevel(subType));
        }
        for (EClass eObjectType : this.getInverseClassesForOneEClassHierarchyLevel(EcorePackage.eINSTANCE.getEObject())) {
            result.add(eObjectType);
        }
        return result;
    }

    private Set<EClass> getInverseClassesForOneEClassHierarchyLevel(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> features = this.inverseFeatures.get(eCls);
        if (features != null) {
            for (EStructuralFeature feature : features) {
                result.add(feature.getEContainingClass());
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getFollowingSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> followingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            followingEStructuralFeatures.addAll(this.getFollowingSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : followingEStructuralFeatures) {
            if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getFollowingSiblingEStructuralFeatures(EStructuralFeature feature) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        if (feature.isMany()) {
            result.add(feature);
        }
        boolean add = false;
        for (EStructuralFeature childFeature : feature.getEContainingClass().getEStructuralFeatures()) {
            if (add && this.isContainingEStructuralFeature(childFeature)) {
                result.add(childFeature);
            }
            boolean bl = add = add || childFeature == feature;
        }
        for (EClass eCls : this.getAllSubTypes(feature.getEContainingClass())) {
            for (EStructuralFeature childFeature : eCls.getEStructuralFeatures()) {
                if (!this.isContainingEStructuralFeature(childFeature)) continue;
                result.add(childFeature);
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getPrecedingSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> precedingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            precedingEStructuralFeatures.addAll(this.getPrecedingSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : precedingEStructuralFeatures) {
            if (!(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getPrecedingSiblingEStructuralFeatures(EStructuralFeature feature) {
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature childFeature : feature.getEContainingClass().getEAllStructuralFeatures()) {
            if (childFeature == feature) break;
            if (!this.isContainingEStructuralFeature(childFeature)) continue;
            result.add(childFeature);
        }
        if (feature.isMany()) {
            result.add(feature);
        }
        return result;
    }

    @Override
    public Set<EClass> getSiblingsEClasses(EClass eCls) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EStructuralFeature> containingEStructuralFeatures = this.getContainingEStructuralFeatures(eCls);
        LinkedHashSet<EStructuralFeature> siblingEStructuralFeatures = new LinkedHashSet<EStructuralFeature>();
        for (EStructuralFeature feature : containingEStructuralFeatures) {
            siblingEStructuralFeatures.addAll(this.getSiblingEStructuralFeatures(feature));
        }
        for (EStructuralFeature feature : siblingEStructuralFeatures) {
            if (!this.isContainingEStructuralFeature(feature) || !(feature.getEType() instanceof EClass)) continue;
            result.add((EClass)feature.getEType());
        }
        return result;
    }

    private Set<EStructuralFeature> getSiblingEStructuralFeatures(EStructuralFeature feature) {
        Set<EStructuralFeature> preceding = this.getPrecedingSiblingEStructuralFeatures(feature);
        Set<EStructuralFeature> following = this.getFollowingSiblingEStructuralFeatures(feature);
        LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>(preceding.size() + following.size());
        result.addAll(preceding);
        result.addAll(following);
        return result;
    }

    @Override
    public Set<EPackage> getRegisteredEPackages() {
        LinkedHashSet<EPackage> res = new LinkedHashSet<EPackage>();
        for (Set<EPackage> ePkgs : this.ePackages.values()) {
            res.addAll(ePkgs);
        }
        return res;
    }
}

