/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import org.eclipse.acceleo.ui.interpreter.completeocl.IEvaluationExporter;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.ConstraintResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OCLResult;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.OperationElement;
import org.eclipse.acceleo.ui.interpreter.completeocl.evaluationresult.Severity;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class AbstractExporter
implements IEvaluationExporter {
    protected final List<ConstraintElement> constraintsSuccess = new ArrayList<ConstraintElement>();
    protected final List<ConstraintElement> constraintsErrors = new ArrayList<ConstraintElement>();
    protected final List<ConstraintElement> constraintsWarnings = new ArrayList<ConstraintElement>();
    protected final List<ConstraintElement> constraintsInfos = new ArrayList<ConstraintElement>();
    protected final List<OperationElement> operationsSuccess = new ArrayList<OperationElement>();
    protected final List<OperationElement> operationsErrors = new ArrayList<OperationElement>();
    protected final List<OperationElement> operationsWarnings = new ArrayList<OperationElement>();
    protected final List<OperationElement> operationsInfos = new ArrayList<OperationElement>();

    private void clearLists() {
        this.constraintsSuccess.clear();
        this.constraintsErrors.clear();
        this.constraintsWarnings.clear();
        this.constraintsInfos.clear();
        this.operationsSuccess.clear();
        this.operationsErrors.clear();
        this.operationsWarnings.clear();
        this.operationsInfos.clear();
    }

    protected abstract void createContents(Appendable var1, String var2, OCLElement var3) throws IOException;

    @Override
    public void export(String outputPath, OCLElement resultRoot, IProgressMonitor monitor) throws IOException, CoreException {
        StringBuilder s = new StringBuilder();
        File targetFile = new File(outputPath);
        try {
            this.export(s, targetFile.getName(), resultRoot);
            byte[] byteArrayInputStream = s.toString().getBytes(Charset.forName("UTF-8"));
            if (targetFile.isAbsolute()) {
                Files.write((byte[])byteArrayInputStream, (File)targetFile);
            } else {
                ByteArrayInputStream contentStream = new ByteArrayInputStream(byteArrayInputStream);
                IFile exportedIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(outputPath));
                exportedIFile.create((InputStream)contentStream, true, monitor);
            }
        }
        catch (IOException iOException) {}
    }

    public void export(Appendable s, String outputFileName, OCLElement resultRoot) throws IOException {
        this.populateAllLists(resultRoot);
        this.createContents(s, outputFileName, resultRoot);
        this.clearLists();
    }

    protected int getConstraintsCount() {
        return this.constraintsErrors.size() + this.constraintsInfos.size() + this.constraintsSuccess.size() + this.constraintsWarnings.size();
    }

    protected int getOperationsCount() {
        return this.operationsErrors.size() + this.operationsInfos.size() + this.operationsSuccess.size() + this.operationsWarnings.size();
    }

    protected String getMessage(OCLResult result) {
        if (result == null) {
            return null;
        }
        StringWriter message = new StringWriter();
        if (result instanceof ConstraintResult) {
            message.append(((ConstraintResult)result).getMessage());
        }
        return message.toString();
    }

    protected String getSeverity(Result result) {
        if (result != null && result instanceof ConstraintResult) {
            return ((ConstraintResult)((Object)result)).getSeverity().toString();
        }
        return null;
    }

    private void populateAllLists(OCLElement oclElement) {
        for (OCLElement child : oclElement.getChildren()) {
            if (child instanceof ConstraintElement) {
                this.populateConstraintsLists((ConstraintElement)child);
                continue;
            }
            if (child instanceof OperationElement) {
                this.populateOperationsLists((OperationElement)child);
                continue;
            }
            for (OCLElement element : child.getChildren()) {
                this.populateAllLists(element);
            }
        }
    }

    private void populateConstraintsLists(ConstraintElement constraintElement) {
        Severity severity = constraintElement.getWorstSeverity();
        if (severity != null) {
            switch (severity.getValue()) {
                case 0: {
                    this.constraintsSuccess.add(constraintElement);
                    break;
                }
                case 4: {
                    this.constraintsErrors.add(constraintElement);
                    break;
                }
                case 2: {
                    this.constraintsWarnings.add(constraintElement);
                    break;
                }
                case 1: {
                    this.constraintsInfos.add(constraintElement);
                    break;
                }
            }
        }
    }

    private void populateOperationsLists(OperationElement operationElement) {
        Severity severity = operationElement.getWorstSeverity();
        if (severity != null) {
            switch (severity.getValue()) {
                case 0: {
                    this.operationsSuccess.add(operationElement);
                    break;
                }
                case 4: {
                    this.operationsErrors.add(operationElement);
                    break;
                }
                case 2: {
                    this.operationsWarnings.add(operationElement);
                    break;
                }
                case 1: {
                    this.operationsInfos.add(operationElement);
                    break;
                }
            }
        }
    }
}

