/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.LongStream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.BlockBasedFile;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheConfig;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheStats;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.pack.PackExt;

final class ClockBlockCacheTable
implements DfsBlockCacheTable {
    private final String name;
    private final int tableSize;
    private final long maxBytes;
    private final int blockSize;
    private final Hash hash;
    private final AtomicReferenceArray<HashEntry> table;
    private final ReentrantLock[] loadLocks;
    private final ReentrantLock[][] refLocks;
    private final ReentrantLock clockLock;
    private DfsBlockCache.Ref clockHand;
    private final DfsBlockCacheStats dfsBlockCacheStats;
    private final Consumer<Long> refLockWaitTime;
    private final DfsBlockCacheConfig.IndexEventConsumer indexEventConsumer;
    private final Map<EvictKey, Long> indexEvictionMap = new ConcurrentHashMap<EvictKey, Long>();

    ClockBlockCacheTable(DfsBlockCacheConfig cfg) {
        this.tableSize = ClockBlockCacheTable.tableSize(cfg);
        if (this.tableSize < 1) {
            throw new IllegalArgumentException(JGitText.get().tSizeMustBeGreaterOrEqual1);
        }
        int concurrencyLevel = cfg.getConcurrencyLevel();
        this.maxBytes = cfg.getBlockLimit();
        this.blockSize = cfg.getBlockSize();
        int blockSizeShift = Integer.numberOfTrailingZeros(this.blockSize);
        this.hash = new Hash(blockSizeShift);
        this.table = new AtomicReferenceArray(this.tableSize);
        this.loadLocks = new ReentrantLock[concurrencyLevel];
        int i = 0;
        while (i < this.loadLocks.length) {
            this.loadLocks[i] = new ReentrantLock(true);
            ++i;
        }
        this.refLocks = new ReentrantLock[PackExt.values().length][concurrencyLevel];
        i = 0;
        while (i < PackExt.values().length) {
            int j = 0;
            while (j < concurrencyLevel) {
                this.refLocks[i][j] = new ReentrantLock(true);
                ++j;
            }
            ++i;
        }
        this.clockLock = new ReentrantLock(true);
        String none = "";
        this.clockHand = new DfsBlockCache.Ref<Object>(DfsStreamKey.of(new DfsRepositoryDescription(none), none, null), -1L, 0L, null);
        this.clockHand.next = this.clockHand;
        this.name = cfg.getName();
        this.dfsBlockCacheStats = new DfsBlockCacheStats(this.name);
        this.refLockWaitTime = cfg.getRefLockWaitTimeConsumer();
        this.indexEventConsumer = cfg.getIndexEventConsumer();
    }

    @Override
    public List<DfsBlockCacheTable.BlockCacheStats> getBlockCacheStats() {
        return List.of(this.dfsBlockCacheStats);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasBlock0(DfsStreamKey key) {
        HashEntry e1 = this.table.get(this.slot(key, 0L));
        DfsBlock v = (DfsBlock)this.scan(e1, key, 0L);
        return v != null && v.contains(key, 0L);
    }

    @Override
    public DfsBlock getOrLoad(BlockBasedFile file, long position, DfsReader ctx, DfsBlockCache.ReadableChannelSupplier fileChannel) throws IOException {
        long requestedPosition = position;
        DfsStreamKey key = file.key;
        int slot = this.slot(key, position = file.alignToBlock(position));
        HashEntry e1 = this.table.get(slot);
        DfsBlock v = (DfsBlock)this.scan(e1, key, position);
        if (v != null && v.contains(key, requestedPosition)) {
            ++ctx.stats.blockCacheHit;
            this.dfsBlockCacheStats.incrementHit(key);
            return v;
        }
        this.reserveSpace(this.blockSize, key);
        ReentrantLock regionLock = this.lockFor(key, position);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (v = (DfsBlock)this.scan(e2, key, position)) != null) {
                ++ctx.stats.blockCacheHit;
                this.dfsBlockCacheStats.incrementHit(key);
                this.creditSpace(this.blockSize, key);
                DfsBlock dfsBlock = v;
                return dfsBlock;
            }
            this.dfsBlockCacheStats.incrementMiss(key);
            boolean credit = true;
            try {
                v = file.readOneBlock(position, ctx, fileChannel.get());
                credit = false;
            }
            finally {
                if (credit) {
                    this.creditSpace(this.blockSize, key);
                }
            }
            if (position != v.start) {
                position = v.start;
                slot = this.slot(key, position);
                e2 = this.table.get(slot);
            }
            DfsBlockCache.Ref<DfsBlock> ref = new DfsBlockCache.Ref<DfsBlock>(key, position, v.size(), v);
            ref.markHotter();
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(HashEntry.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref, this.blockSize - v.size());
        }
        finally {
            regionLock.unlock();
        }
        if (v.contains(file.key, requestedPosition)) {
            return v;
        }
        return this.getOrLoad(file, requestedPosition, ctx, fileChannel);
    }

    @Override
    public <T> DfsBlockCache.Ref<T> getOrLoadRef(DfsStreamKey key, long position, DfsBlockCache.RefLoader<T> loader) throws IOException {
        long start = System.nanoTime();
        int slot = this.slot(key, position);
        HashEntry e1 = this.table.get(slot);
        DfsBlockCache.Ref<T> ref = this.scanRef(e1, key, position);
        if (ref != null) {
            this.dfsBlockCacheStats.incrementHit(key);
            this.reportIndexRequested(ref, true, start);
            return ref;
        }
        ReentrantLock regionLock = this.lockForRef(key);
        long lockStart = System.currentTimeMillis();
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (ref = this.scanRef(e2, key, position)) != null) {
                this.dfsBlockCacheStats.incrementHit(key);
                this.reportIndexRequested(ref, true, start);
                DfsBlockCache.Ref<T> ref2 = ref;
                return ref2;
            }
            if (this.refLockWaitTime != null) {
                this.refLockWaitTime.accept(System.currentTimeMillis() - lockStart);
            }
            this.dfsBlockCacheStats.incrementMiss(key);
            ref = loader.load();
            ref.markHotter();
            this.reserveSpace(ref.size, key);
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(HashEntry.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref, 0L);
        }
        finally {
            regionLock.unlock();
        }
        this.reportIndexRequested(ref, false, start);
        return ref;
    }

    @Override
    public void put(DfsBlock v) {
        this.put(v.stream, v.start, v.size(), v);
    }

    @Override
    public <T> DfsBlockCache.Ref<T> put(DfsStreamKey key, long pos, long size, T v) {
        int slot = this.slot(key, pos);
        HashEntry e1 = this.table.get(slot);
        DfsBlockCache.Ref<T> ref = this.scanRef(e1, key, pos);
        if (ref != null) {
            return ref;
        }
        this.reserveSpace(size, key);
        ReentrantLock regionLock = this.lockFor(key, pos);
        regionLock.lock();
        try {
            HashEntry n;
            HashEntry e2 = this.table.get(slot);
            if (e2 != e1 && (ref = this.scanRef(e2, key, pos)) != null) {
                this.creditSpace(size, key);
                DfsBlockCache.Ref<T> ref2 = ref;
                return ref2;
            }
            ref = new DfsBlockCache.Ref<T>(key, pos, size, v);
            ref.markHotter();
            while (!this.table.compareAndSet(slot, e2, n = new HashEntry(HashEntry.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
            this.addToClock(ref, 0L);
        }
        finally {
            regionLock.unlock();
        }
        return ref;
    }

    @Override
    public <T> DfsBlockCache.Ref<T> putRef(DfsStreamKey key, long size, T v) {
        return this.put(key, 0L, size, v);
    }

    @Override
    public boolean contains(DfsStreamKey key, long position) {
        return this.scan(this.table.get(this.slot(key, position)), key, position) != null;
    }

    @Override
    public <T> T get(DfsStreamKey key, long position) {
        T val = this.scan(this.table.get(this.slot(key, position)), key, position);
        if (val == null) {
            this.dfsBlockCacheStats.incrementMiss(key);
        } else {
            this.dfsBlockCacheStats.incrementHit(key);
        }
        return val;
    }

    private int slot(DfsStreamKey key, long position) {
        return (this.hash.hash(key.hash, position) >>> 1) % this.tableSize;
    }

    private void reserveSpace(long reserve, DfsStreamKey key) {
        this.clockLock.lock();
        try {
            long live = LongStream.of(this.dfsBlockCacheStats.getCurrentSize()).sum() + reserve;
            if (this.maxBytes < live) {
                DfsBlockCache.Ref prev = this.clockHand;
                DfsBlockCache.Ref hand = this.clockHand.next;
                do {
                    if (hand.isHot()) {
                        hand.markColder();
                        prev = hand;
                        hand = hand.next;
                        continue;
                    }
                    if (prev == hand) break;
                    DfsBlockCache.Ref dead = hand;
                    prev.next = hand = hand.next;
                    dead.next = null;
                    dead.value = null;
                    live -= dead.size;
                    this.dfsBlockCacheStats.addToLiveBytes(dead.key, -dead.size);
                    this.dfsBlockCacheStats.incrementEvict(dead.key);
                    this.reportIndexEvicted(dead);
                } while (this.maxBytes < live);
                this.clockHand = prev;
            }
            this.dfsBlockCacheStats.addToLiveBytes(key, reserve);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void creditSpace(long credit, DfsStreamKey key) {
        this.clockLock.lock();
        try {
            this.dfsBlockCacheStats.addToLiveBytes(key, -credit);
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private void addToClock(DfsBlockCache.Ref ref, long credit) {
        this.clockLock.lock();
        try {
            if (credit != 0L) {
                this.dfsBlockCacheStats.addToLiveBytes(ref.key, -credit);
            }
            DfsBlockCache.Ref ptr = this.clockHand;
            ref.next = ptr.next;
            ptr.next = ref;
            this.clockHand = ref;
        }
        finally {
            this.clockLock.unlock();
        }
    }

    private <T> T scan(HashEntry n, DfsStreamKey key, long position) {
        DfsBlockCache.Ref<T> r = this.scanRef(n, key, position);
        return r != null ? (T)r.get() : null;
    }

    private <T> DfsBlockCache.Ref<T> scanRef(HashEntry n, DfsStreamKey key, long position) {
        while (n != null) {
            DfsBlockCache.Ref r = n.ref;
            if (r.position == position && r.key.equals(key)) {
                return r.get() != null ? r : null;
            }
            n = n.next;
        }
        return null;
    }

    private ReentrantLock lockFor(DfsStreamKey key, long position) {
        return this.loadLocks[(this.hash.hash(key.hash, position) >>> 1) % this.loadLocks.length];
    }

    private ReentrantLock lockForRef(DfsStreamKey key) {
        int slot = (key.hash >>> 1) % this.refLocks[key.packExtPos].length;
        return this.refLocks[key.packExtPos][slot];
    }

    private void reportIndexRequested(DfsBlockCache.Ref<?> ref, boolean cacheHit, long start) {
        if (this.indexEventConsumer == null || !ClockBlockCacheTable.isIndexExtPos(ref.key.packExtPos)) {
            return;
        }
        EvictKey evictKey = this.createEvictKey(ref);
        Long prevEvictedTime = this.indexEvictionMap.get(evictKey);
        long now = System.nanoTime();
        long sinceLastEvictionNanos = prevEvictedTime == null ? 0L : now - prevEvictedTime;
        this.indexEventConsumer.acceptRequestedEvent(ref.key.packExtPos, cacheHit, (now - start) / 1000L, ref.size, Duration.ofNanos(sinceLastEvictionNanos));
    }

    private void reportIndexEvicted(DfsBlockCache.Ref<?> dead) {
        if (this.indexEventConsumer == null || !this.indexEventConsumer.shouldReportEvictedEvent() || !ClockBlockCacheTable.isIndexExtPos(dead.key.packExtPos)) {
            return;
        }
        EvictKey evictKey = this.createEvictKey(dead);
        Long prevEvictedTime = this.indexEvictionMap.get(evictKey);
        long now = System.nanoTime();
        long sinceLastEvictionNanos = prevEvictedTime == null ? 0L : now - prevEvictedTime;
        this.indexEvictionMap.put(evictKey, now);
        this.indexEventConsumer.acceptEvictedEvent(dead.key.packExtPos, dead.size, dead.getTotalHitCount(), Duration.ofNanos(sinceLastEvictionNanos));
    }

    private EvictKey createEvictKey(DfsBlockCache.Ref<?> ref) {
        return new EvictKey(this.hash, ref);
    }

    private static boolean isIndexExtPos(int packExtPos) {
        return packExtPos == PackExt.INDEX.getPosition() || packExtPos == PackExt.REVERSE_INDEX.getPosition() || packExtPos == PackExt.BITMAP_INDEX.getPosition();
    }

    private static int tableSize(DfsBlockCacheConfig cfg) {
        int wsz = cfg.getBlockSize();
        long limit = cfg.getBlockLimit();
        if (wsz <= 0) {
            throw new IllegalArgumentException(JGitText.get().invalidWindowSize);
        }
        if (limit < (long)wsz) {
            throw new IllegalArgumentException(JGitText.get().windowSizeMustBeLesserThanLimit);
        }
        return (int)Math.min(5L * (limit / (long)wsz) / 2L, Integer.MAX_VALUE);
    }

    private static final class EvictKey {
        private final Hash hash;
        private final int keyHash;
        private final int packExtPos;
        private final long position;

        EvictKey(Hash hash, DfsBlockCache.Ref<?> ref) {
            this.hash = hash;
            this.keyHash = ref.key.hash;
            this.packExtPos = ref.key.packExtPos;
            this.position = ref.position;
        }

        public boolean equals(Object object) {
            if (object instanceof EvictKey) {
                EvictKey other = (EvictKey)object;
                return this.keyHash == other.keyHash && this.packExtPos == other.packExtPos && this.position == other.position;
            }
            return false;
        }

        public int hashCode() {
            return this.hash.hash(this.keyHash, this.position);
        }
    }

    private static final class Hash {
        private final int blockSizeShift;

        Hash(int blockSizeShift) {
            this.blockSizeShift = blockSizeShift;
        }

        int hash(int packHash, long off) {
            return packHash + (int)(off >>> this.blockSizeShift);
        }
    }

    private static final class HashEntry {
        final HashEntry next;
        final DfsBlockCache.Ref ref;

        HashEntry(HashEntry n, DfsBlockCache.Ref r) {
            this.next = n;
            this.ref = r;
        }

        private static HashEntry clean(HashEntry top) {
            while (top != null && top.ref.next == null) {
                top = top.next;
            }
            if (top == null) {
                return null;
            }
            HashEntry n = HashEntry.clean(top.next);
            return n == top.next ? top : new HashEntry(n, top.ref);
        }
    }
}

