/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayer
extends AbstractRowHideShowLayer {
    private static final Logger LOG = LoggerFactory.getLogger(TreeLayer.class);
    public static final String TREE_COLUMN_CELL = "TREE_COLUMN_CELL";
    public static final int TREE_COLUMN_NUMBER = 0;
    private boolean useTreeColumnIndex = false;
    private final ITreeRowModel<?> treeRowModel;
    private MutableIntSet hiddenRowIndexes = IntSets.mutable.empty();
    private IndentedTreeImagePainter indentedTreeImagePainter;

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter());
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter) {
        this(underlyingLayer, treeRowModel, indentedTreeImagePainter, true);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter(), useDefaultConfiguration);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.treeRowModel = treeRowModel;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultTreeLayerConfiguration(this));
        }
        this.indentedTreeImagePainter = indentedTreeImagePainter;
        this.registerCommandHandler(new TreeExpandCollapseCommandHandler(this));
        this.registerCommandHandler(new TreeCollapseAllCommandHandler(this));
        this.registerCommandHandler(new TreeExpandAllCommandHandler(this));
        this.registerCommandHandler(new TreeExpandToLevelCommandHandler(this));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.isTreeColumn(columnPosition)) {
            configLabels.addLabelOnTop(TREE_COLUMN_CELL);
            ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
            if (cell != null) {
                int rowIndex = this.getRowIndexByPosition(cell.getOriginRowPosition());
                configLabels.addLabelOnTop("TREE_DEPTH_" + this.treeRowModel.depth(rowIndex));
                if (!this.treeRowModel.hasChildren(rowIndex)) {
                    configLabels.addLabelOnTop("TREE_LEAF");
                } else if (this.treeRowModel.isCollapsed(rowIndex)) {
                    configLabels.addLabelOnTop("TREE_COLLAPSED");
                } else {
                    configLabels.addLabelOnTop("TREE_EXPANDED");
                }
            }
        }
        return configLabels;
    }

    public ITreeRowModel<?> getModel() {
        return this.treeRowModel;
    }

    protected boolean isTreeColumn(int columnPosition) {
        if (this.useTreeColumnIndex) {
            return this.getColumnIndexByPosition(columnPosition) == 0;
        }
        return columnPosition == 0;
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        ICellPainter cellPainter = super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        if (cell.getConfigLabels().hasLabel(TREE_COLUMN_CELL)) {
            ICellPainter treeCellPainter = configRegistry.getConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, cell.getDisplayMode(), (List<String>)cell.getConfigLabels());
            if (treeCellPainter != null) {
                IndentedTreeImagePainter treePainter = this.findIndentedTreeImagePainter(treeCellPainter);
                if (treePainter != null) {
                    treePainter.setBaseCellPainter(cellPainter);
                    cellPainter = treeCellPainter;
                } else {
                    LOG.warn("There is no IndentedTreeImagePainter found for TREE_STRUCTURE_PAINTER, using local configured IndentedTreeImagePainter as fallback");
                    this.indentedTreeImagePainter.setBaseCellPainter(cellPainter);
                    cellPainter = new BackgroundPainter(this.indentedTreeImagePainter);
                }
            } else {
                this.indentedTreeImagePainter.setBaseCellPainter(cellPainter);
                cellPainter = new BackgroundPainter(this.indentedTreeImagePainter);
            }
        }
        return cellPainter;
    }

    private IndentedTreeImagePainter findIndentedTreeImagePainter(ICellPainter painter) {
        IndentedTreeImagePainter result = null;
        if (painter instanceof IndentedTreeImagePainter) {
            result = (IndentedTreeImagePainter)painter;
        } else if (painter instanceof CellPainterWrapper && ((CellPainterWrapper)painter).getWrappedPainter() != null) {
            result = this.findIndentedTreeImagePainter(((CellPainterWrapper)painter).getWrappedPainter());
        } else if (painter instanceof CellPainterDecorator && (result = this.findIndentedTreeImagePainter(((CellPainterDecorator)painter).getBaseCellPainter())) == null) {
            result = this.findIndentedTreeImagePainter(((CellPainterDecorator)painter).getDecoratorCellPainter());
        }
        return result;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex) || this.isHiddenInUnderlyingLayer(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return ArrayUtil.asIntegerList(this.hiddenRowIndexes.toSortedArray());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        return this.hiddenRowIndexes.toSortedArray();
    }

    @Override
    public boolean hasHiddenRows() {
        return !this.hiddenRowIndexes.isEmpty();
    }

    public void expandOrCollapseIndex(int parentIndex) {
        if (this.treeRowModel.isCollapsed(parentIndex)) {
            this.expandTreeRow(parentIndex);
        } else {
            this.collapseTreeRow(parentIndex);
        }
    }

    public void collapseTreeRow(int parentIndex) {
        int[] rowIndexes = this.treeRowModel.collapse(parentIndex).stream().mapToInt(Integer::intValue).sorted().toArray();
        int[] rowPositions = Arrays.stream(rowIndexes).map(this::getRowPositionByIndex).filter(rowPos -> rowPos >= 0).sorted().toArray();
        int[] hiddenIndexes = Arrays.stream(rowPositions).map(this::getRowIndexByPosition).sorted().toArray();
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, hiddenIndexes));
    }

    public void collapseAll() {
        int[] rowIndexes = this.treeRowModel.collapseAll().stream().mapToInt(Integer::intValue).sorted().toArray();
        int[] rowPositions = Arrays.stream(rowIndexes).map(this::getRowPositionByIndex).filter(rowPos -> rowPos >= 0).sorted().toArray();
        int[] hiddenIndexes = Arrays.stream(rowPositions).map(this::getRowIndexByPosition).sorted().toArray();
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions, hiddenIndexes));
    }

    public void expandTreeRow(int parentIndex) {
        this.internalExpand(this.treeRowModel.expand(parentIndex));
    }

    public void expandTreeRowToLevel(int parentIndex, int level) {
        this.internalExpand(this.treeRowModel.expandToLevel(parentIndex, level));
    }

    public void expandAll() {
        List<Integer> rowIndexes = this.treeRowModel.expandAll();
        this.hiddenRowIndexes = IntSets.mutable.empty();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, rowIndexes.stream().mapToInt(this::getRowPositionByIndex).filter(r -> r >= 0).sorted().toArray()));
    }

    public void expandAllToLevel(int level) {
        this.internalExpand(this.treeRowModel.expandToLevel(level));
    }

    private void internalExpand(List<Integer> rowIndexes) {
        this.hiddenRowIndexes.removeAll(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, rowIndexes.stream().mapToInt(this::getRowPositionByIndex).filter(r -> r >= 0).sorted().toArray()));
    }

    private boolean isHiddenInUnderlyingLayer(int rowIndex) {
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowHideCommand) {
            return this.handleRowHideCommand((RowHideCommand)command);
        }
        if (command instanceof MultiRowHideCommand) {
            return this.handleMultiRowHideCommand((MultiRowHideCommand)command);
        }
        return super.doCommand(command);
    }

    protected boolean handleRowHideCommand(RowHideCommand command) {
        int rowIndex;
        if (command.convertToTargetLayer(this) && this.treeRowModel.hasChildren(rowIndex = this.getRowIndexByPosition(command.getRowPosition())) && !this.treeRowModel.isCollapsed(rowIndex)) {
            List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
            int[] childPositions = new int[childIndexes.size() + 1];
            childPositions[0] = command.getRowPosition();
            int i = 1;
            while (i < childIndexes.size() + 1) {
                int childPos;
                childPositions[i] = childPos = this.getRowPositionByIndex(childIndexes.get(i - 1));
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }

    protected boolean handleMultiRowHideCommand(MultiRowHideCommand command) {
        if (command.convertToTargetLayer(this)) {
            ArrayList<Integer> rowPositionsToHide = new ArrayList<Integer>();
            int[] nArray = command.getRowPositionsArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int rowPos = nArray[n2];
                rowPositionsToHide.add(rowPos);
                int rowIndex = this.getRowIndexByPosition(rowPos);
                if (this.treeRowModel.hasChildren(rowIndex) && !this.treeRowModel.isCollapsed(rowIndex)) {
                    List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
                    for (Integer childIndex : childIndexes) {
                        rowPositionsToHide.add(this.getRowPositionByIndex(childIndex));
                    }
                }
                ++n2;
            }
            int[] childPositions = new int[rowPositionsToHide.size()];
            int i = 0;
            while (i < rowPositionsToHide.size()) {
                childPositions[i] = (Integer)rowPositionsToHide.get(i);
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }

    public boolean isUseTreeColumnIndex() {
        return this.useTreeColumnIndex;
    }

    public void setUseTreeColumnIndex(boolean useTreeColumnIndex) {
        this.useTreeColumnIndex = useTreeColumnIndex;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add(TREE_COLUMN_CELL);
        result.add("TREE_LEAF");
        result.add("TREE_COLLAPSED");
        result.add("TREE_EXPANDED");
        result.add("TREE_DEPTH_0");
        result.add("TREE_DEPTH_1");
        result.add("TREE_DEPTH_2");
        result.add("TREE_DEPTH_3");
        result.add("TREE_DEPTH_4");
        return result;
    }
}

