/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Activator;
import org.eclipse.fordiac.ide.systemmanagement.ui.commands.NewAppCommand;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.NewSystemWizardPage;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewSystemWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewSystemWizardPage page;

    public NewSystemWizard() {
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(FordiacMessages.NewType);
    }

    public void addPages() {
        this.page = new NewSystemWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    IProgressMonitor monitorToUse = monitor == null ? new NullProgressMonitor() : monitor;
                    AutomationSystem system = SystemManager.INSTANCE.createNewSystem(NewSystemWizard.this.getSystemLocation(), NewSystemWizard.this.page.getSystemName());
                    TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)system);
                    NewSystemWizard.this.createInitialApplication(monitorToUse, system);
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private final IContainer getSystemLocation() {
        IPath targetPath = this.getTargetFile().getParent().getLocation();
        return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(targetPath);
    }

    private final IFile getTargetFile() {
        String sysName = this.page.getSystemName();
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        return wsr.getFile((IPath)new Path(this.page.getContainerFullPath() + File.separator + sysName));
    }

    private void createInitialApplication(IProgressMonitor monitor, AutomationSystem system) {
        NewAppCommand cmd = new NewAppCommand(system, this.page.getInitialApplicationName(), "");
        cmd.execute(monitor, null);
        Application app = cmd.getApplication();
        if (this.page.getOpenApplication() && app != null) {
            OpenListenerManager.openEditor((EObject)app);
        }
    }
}

