/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.util.IdentifierVerifyListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewApplicationPage
extends WizardPage {
    private final AutomationSystem system;
    private Text applicationName;
    private Button openApplicationCheckbox;

    protected NewApplicationPage(AutomationSystem system) {
        super(Messages.NewApplicationWizardTitle);
        this.setTitle(Messages.NewApplicationWizardTitle);
        this.system = system;
        this.setDescription(MessageFormat.format(Messages.NewApplicationPage_NewApplicationDescription, system != null ? system.getName() : Messages.NewApplicationPage_ErrorMessageNoSystemSelected));
    }

    public String getApplicationName() {
        return this.applicationName.getText();
    }

    public boolean getOpenApplication() {
        return this.openApplicationCheckbox.getSelection();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createApplicationNameGroup(composite);
        this.createOpenApplication(composite);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createApplicationNameGroup(Composite composite) {
        Label l = new Label(composite, 0);
        l.setText(String.valueOf(FordiacMessages.ApplicationName) + ":");
        l.setLayoutData((Object)new GridData(768));
        this.applicationName = new Text(composite, 2052);
        this.applicationName.setLayoutData((Object)new GridData(768));
        this.applicationName.addModifyListener(e -> this.setPageComplete(this.validatePage()));
        this.applicationName.addVerifyListener((VerifyListener)new IdentifierVerifyListener());
    }

    private void createOpenApplication(Composite parent) {
        this.openApplicationCheckbox = new Button(parent, 32);
        this.openApplicationCheckbox.setText(Messages.NewApplicationPage_OpenApplicationForEditing);
        this.openApplicationCheckbox.setSelection(true);
    }

    protected boolean validatePage() {
        if (this.system == null) {
            this.setErrorMessage(Messages.NewApplicationPage_ErrorMessageNoSystemSelected);
            return false;
        }
        if (this.applicationName.getText().isEmpty()) {
            this.setErrorMessage(Messages.NewApplicationPage_ErrorMessage_EmptyElementName);
            return false;
        }
        if (!NewApplicationPage.isValidAppName(this.applicationName.getText(), this.system)) {
            this.setErrorMessage(Messages.NewApplicationPage_ErrorMessageInvalidAppName);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private static boolean isValidAppName(String appNameProposal, AutomationSystem selectedSystem) {
        if (!IdentifierVerifyer.isValidIdentifier((String)appNameProposal)) {
            return false;
        }
        for (Application app : selectedSystem.getApplication()) {
            if (!appNameProposal.equalsIgnoreCase(app.getName())) continue;
            return false;
        }
        return true;
    }
}

