/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.linkhelpers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditorInput;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.systemmanagement.ui.linkhelpers.AbstractEditorLinkHelper;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class ApplicationSubAppEditorLinkHelper
extends AbstractEditorLinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        if (anInput instanceof ApplicationEditorInput) {
            ApplicationEditorInput appInput = (ApplicationEditorInput)anInput;
            return new StructuredSelection((Object)appInput.getContent());
        }
        if (anInput instanceof SubApplicationEditorInput) {
            SubApplicationEditorInput subAppInput = (SubApplicationEditorInput)anInput;
            return new StructuredSelection((Object)subAppInput.getSubApp());
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (aSelection.getFirstElement() instanceof Application) {
            ApplicationSubAppEditorLinkHelper.performEditorSelect(aPage, (IEditorInput)new ApplicationEditorInput((Application)aSelection.getFirstElement()), null);
        }
        if (aSelection.getFirstElement() instanceof SubApp && !((SubApp)aSelection.getFirstElement()).isTyped()) {
            ApplicationSubAppEditorLinkHelper.handleUntypedSubApp(aPage, (SubApp)aSelection.getFirstElement());
        } else if (aSelection.getFirstElement() instanceof FBNetworkElement) {
            FBNetworkElement refElement = (FBNetworkElement)aSelection.getFirstElement();
            ApplicationSubAppEditorLinkHelper.performFBNElementSelection(aPage, refElement);
        }
    }

    private static void performEditorSelect(IWorkbenchPage aPage, IEditorInput editorInput, FBNetworkElement refElement) {
        IEditorPart editor = ApplicationSubAppEditorLinkHelper.activateEditor(aPage, editorInput);
        HandlerHelper.selectElement((Object)refElement, (IEditorPart)editor);
    }

    private static void handleUntypedSubApp(IWorkbenchPage aPage, SubApp subApp) {
        IEditorPart editor = ApplicationSubAppEditorLinkHelper.activateEditor(aPage, (IEditorInput)ApplicationSubAppEditorLinkHelper.generateSubAppEditorInput(subApp));
        if (editor == null) {
            ApplicationSubAppEditorLinkHelper.performFBNElementSelection(aPage, (FBNetworkElement)subApp);
        }
    }

    private static SubApplicationEditorInput generateSubAppEditorInput(SubApp subApp) {
        return new SubApplicationEditorInput(subApp);
    }

    private static void performFBNElementSelection(IWorkbenchPage aPage, FBNetworkElement refElement) {
        EObject fbCont = refElement.eContainer();
        if (fbCont instanceof FBNetwork) {
            EObject obj = ((FBNetwork)fbCont).eContainer();
            if (obj instanceof Application) {
                ApplicationSubAppEditorLinkHelper.performEditorSelect(aPage, (IEditorInput)new ApplicationEditorInput((Application)obj), refElement);
            } else if (obj instanceof SubApp) {
                ApplicationSubAppEditorLinkHelper.performEditorSelect(aPage, (IEditorInput)ApplicationSubAppEditorLinkHelper.generateSubAppEditorInput((SubApp)obj), refElement);
            }
        }
    }
}

