/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteSystem
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List<IProject> projectSelection = DeleteSystem.getSelectedProjects(selection);
        DeleteSystem.runDeleteAction(projectSelection);
        return null;
    }

    private static void runDeleteAction(List<IProject> projectSelection) {
        DeleteResourceAction action = new DeleteResourceAction(() -> Display.getDefault().getActiveShell());
        action.selectionChanged((IStructuredSelection)new StructuredSelection(projectSelection));
        action.run();
    }

    private static List<IProject> getSelectedProjects(ISelection selection) {
        ArrayList<IProject> projectSelection = new ArrayList<IProject>();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (element instanceof AutomationSystem) {
                    projectSelection.add(((AutomationSystem)element).getSystemFile().getProject());
                    continue;
                }
                if (!(element instanceof IProject)) continue;
                projectSelection.add((IProject)element);
            }
        }
        return projectSelection;
    }
}

