/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.commands;

import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;

public class NewAppCommand
extends AbstractOperation {
    private AutomationSystem system;
    private String appName;
    private String comment;
    private Application application;

    public NewAppCommand(AutomationSystem system, String appName, String comment) {
        super(Messages.NewApplicationCommand_LABEL_NewApplication);
        this.system = system;
        this.appName = appName;
        this.comment = comment;
    }

    public Application getApplication() {
        return this.application;
    }

    public boolean canExecute() {
        return this.system != null && this.appName != null && this.comment != null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        if (this.system != null) {
            this.application = NewAppCommand.creatApplicationElement();
            this.application.setName(this.appName);
            this.application.setComment(this.comment);
            FBNetwork network = LibraryElementFactory.eINSTANCE.createFBNetwork();
            this.application.setFBNetwork(network);
            this.system.getApplication().add((Object)this.application);
            SystemManager.saveSystem((AutomationSystem)this.system);
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.fordiac.ide.gef", 4, "", null);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        if (this.system != null) {
            this.system.getApplication().add((Object)this.application);
            SystemManager.saveSystem((AutomationSystem)this.system);
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.fordiac.ide.gef", 4, "", null);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        if (this.system != null) {
            this.system.getApplication().remove((Object)this.application);
            SystemManager.saveSystem((AutomationSystem)this.system);
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.fordiac.ide.gef", 4, "", null);
    }

    private static Application creatApplicationElement() {
        return LibraryElementFactory.eINSTANCE.createApplication();
    }
}

