/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.commands;

import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Mapping;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteApplicationCommand
extends Command {
    private Application application;
    private AutomationSystem system;
    private CompoundCommand unmappApplicationElements = new CompoundCommand();

    public DeleteApplicationCommand(Application application) {
        super("Delete Application");
        this.application = application;
        if (application != null) {
            this.system = application.getAutomationSystem();
        }
    }

    public boolean canExecute() {
        return this.application != null && this.system != null;
    }

    public void execute() {
        this.getUnmappCommands();
        this.unmappApplicationElements.execute();
        this.closeApplicationEditor();
        this.system.getApplication().remove((Object)this.application);
        SystemManager.saveSystem((AutomationSystem)this.system);
    }

    public void redo() {
        this.unmappApplicationElements.redo();
        this.system.getApplication().remove((Object)this.application);
        SystemManager.saveSystem((AutomationSystem)this.system);
    }

    public void undo() {
        this.system.getApplication().add((Object)this.application);
        this.unmappApplicationElements.undo();
        SystemManager.saveSystem((AutomationSystem)this.system);
    }

    private void getUnmappCommands() {
        this.application.getFBNetwork().getNetworkElements().stream().forEach(element -> {
            Mapping mapping = element.getMapping();
            if (mapping != null) {
                this.unmappApplicationElements.add((Command)new UnmapCommand(element));
            }
        });
    }

    private void closeApplicationEditor() {
        EditorUtils.closeEditorsFiltered(editor -> editor instanceof FBNetworkEditor && this.application.getFBNetwork().equals(((FBNetworkEditor)editor).getModel()));
    }
}

