/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.fordiac.ide.runtime.Activator;

public final class LaunchRuntimeUtils {
    public static final String ATTR_TOOL_ARGUMENTS = "org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS";

    public static ILaunch startRuntime(String configname, String runtime, String location, String arguments) {
        ILaunch launcht = null;
        DebugPlugin debug = DebugPlugin.getDefault();
        ILaunchManager lm = debug.getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        try {
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configname);
            wc.setAttribute("org.eclipse.debug.core.appendEnvironmentVariables", true);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", runtime);
            wc.setAttribute(ATTR_TOOL_ARGUMENTS, arguments);
            wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", location);
            ILaunchConfiguration config = wc.doSave();
            launcht = config.launch("run", null);
            LaunchRuntimeUtils.waitForOneSecond();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        return launcht;
    }

    private static void waitForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private LaunchRuntimeUtils() {
        throw new UnsupportedOperationException("LaunchRuntimeUtils utility class should not be instantiated!");
    }
}

