/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.resourceediting.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.resourceediting.editparts.ResourceDiagramEditPartFactory;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;

public class ResourceDiagramEditor
extends FBNetworkEditor {
    private final Adapter resourceAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) && ResourceDiagramEditor.this.getResource().equals(notification.getNotifier())) {
                ResourceDiagramEditor.this.updateEditorTitle(ResourceEditorInput.getResourceEditorName(ResourceDiagramEditor.this.getResource()));
            }
            super.notifyChanged(notification);
        }
    };
    private final Adapter colorChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                ResourceDiagramEditor.this.updateGridColor();
            }
        }
    };

    private Resource getResource() {
        return (Resource)this.getModel().eContainer();
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.updateGridColor();
    }

    protected EditPartFactory getEditPartFactory() {
        return new ResourceDiagramEditPartFactory((GraphicalEditor)this);
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new FBNetworkContextMenuProvider((DiagramEditorWithFlyoutPalette)this, this.getActionRegistry(), zoomManager, this.getPalette());
    }

    protected void setModel(IEditorInput input) {
        if (input instanceof ResourceEditorInput) {
            ResourceEditorInput resInput = (ResourceEditorInput)input;
            Resource res = resInput.getContent();
            this.setModel(res.getFBNetwork());
            this.getResource().eAdapters().add((Object)this.resourceAdapter);
            this.getResource().getDevice().eAdapters().add((Object)this.colorChangeListener);
        }
        super.setModel(input);
    }

    public void dispose() {
        if (this.getResource() != null) {
            this.getResource().eAdapters().remove((Object)this.resourceAdapter);
            this.getResource().getDevice().eAdapters().remove((Object)this.colorChangeListener);
        }
        super.dispose();
    }

    private void updateGridColor() {
        Color devColor;
        IFigure layer;
        if (this.getResource() != null && (layer = ((ZoomScalableFreeformRootEditPart)this.getViewer().getRootEditPart()).getLayer((Object)"Grid Layer")) != null && (devColor = this.getResource().getDevice().getColor()) != null) {
            org.eclipse.swt.graphics.Color newColor = ColorManager.getColor((RGB)new RGB(devColor.getRed(), devColor.getGreen(), devColor.getBlue()));
            layer.setForegroundColor(newColor);
        }
    }
}

