/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.monitoring.Activator;
import org.eclipse.fordiac.ide.monitoring.MonitoredSystems;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class MonitorSystemHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            AutomationSystem system = SystemManager.INSTANCE.getSystem((IFile)((TreeSelection)selection).getFirstElement());
            if (!MonitoringManager.getInstance().isSystemMonitored(system)) {
                MonitoringManager.getInstance().enableSystem(system);
            } else {
                MonitoringManager.getInstance().disableSystem(system);
            }
            HandlerUtil.toggleCommandState((Command)event.getCommand());
            MonitoredSystems.refreshSystemTree();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.fordiac.ide.monitoring.MonitorSystem");
        try {
            HandlerUtil.toggleCommandState((Command)command);
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
        this.setBaseEnabled(true);
    }
}

