/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring.decorators;

import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class SystemMonitoringDecorator
implements ILabelDecorator {
    private Image overlayImage = null;

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.overlayImage != null) {
            this.overlayImage.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        Image retval = null;
        if (element instanceof IFile && "sys".equalsIgnoreCase(((IFile)element).getFileExtension())) {
            AutomationSystem system = SystemManager.INSTANCE.getSystem((IFile)element);
            if (MonitoringManager.getInstance().isSystemMonitored(system)) {
                retval = this.getOverlayImage(image);
            }
        } else {
            retval = image;
        }
        return retval;
    }

    private Image getOverlayImage(Image image) {
        if (this.overlayImage == null) {
            DecorationOverlayIcon icon = new DecorationOverlayIcon(image, FordiacImage.ICON_MONITORING_DECORATOR.getImageDescriptor(), 0);
            this.overlayImage = icon.createImage();
        }
        return this.overlayImage;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

