/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.monitoring.MonitoringManager;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.navigator.CommonNavigator;

public class MonitoredSystems
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        ArrayList<ContributionItem> menuList = new ArrayList<ContributionItem>();
        Set<AutomationSystem> systems = MonitoringManager.getInstance().getMonitoredSystems();
        if (systems.isEmpty()) {
            menuList.add(new EmptyMonitoringContribution());
        } else {
            for (AutomationSystem system : MonitoringManager.getInstance().getMonitoredSystems()) {
                menuList.add(new MonitorSystemContribution(system));
            }
        }
        return menuList.toArray(new IContributionItem[menuList.size()]);
    }

    public static void refreshSystemTree() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = page.findView("org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer");
        if (view instanceof CommonNavigator) {
            CommonNavigator treeView = (CommonNavigator)view;
            treeView.getCommonViewer().refresh();
        }
    }

    private static class EmptyMonitoringContribution
    extends ContributionItem {
        private EmptyMonitoringContribution() {
        }

        public void fill(Menu menu, int index) {
            MenuItem item = index == -1 ? new MenuItem(menu, 0) : new MenuItem(menu, 0, index);
            item.setText(FordiacMessages.EmptyField);
            item.setEnabled(false);
        }
    }

    private static class MonitorSystemContribution
    extends ContributionItem {
        private final AutomationSystem system;

        MonitorSystemContribution(AutomationSystem system) {
            this.system = system;
        }

        public void fill(Menu menu, int index) {
            MonitorSystemContribution.createSystemMonitoringMenuEntry(this.system, menu, index);
        }

        private static void createSystemMonitoringMenuEntry(AutomationSystem system, Menu menu, int index) {
            MenuItem item = index == -1 ? new MenuItem(menu, 32) : new MenuItem(menu, 32, index);
            item.setText(system.getName());
            item.setSelection(true);
            item.addSelectionListener((SelectionListener)new SystemMonitoringSelectionAdapter(system));
        }
    }

    private static final class SystemMonitoringSelectionAdapter
    extends SelectionAdapter {
        private final AutomationSystem system;

        private SystemMonitoringSelectionAdapter(AutomationSystem system) {
            this.system = system;
        }

        public void widgetSelected(SelectionEvent e) {
            MenuItem menuItem = (MenuItem)e.getSource();
            MonitoringManager manager = MonitoringManager.getInstance();
            if (menuItem.getSelection()) {
                manager.enableSystem(this.system);
            } else {
                manager.disableSystem(this.system);
            }
            MonitoredSystems.refreshSystemTree();
        }
    }
}

