/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;

public final class EventTypeLibrary {
    private static final String EVENT = "Event";
    private Map<String, DataType> typeMap = new HashMap<String, DataType>();
    private static EventTypeLibrary instance;

    private EventTypeLibrary() {
        this.initElementaryTypes();
    }

    public static EventTypeLibrary getInstance() {
        if (instance == null) {
            instance = new EventTypeLibrary();
        }
        return instance;
    }

    private void initElementaryTypes() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, DataType>();
        }
        EventType type = DataFactory.eINSTANCE.createEventType();
        type.setName(EVENT);
        this.typeMap.put(EVENT, type);
    }

    public Collection<DataType> getEventTypes() {
        return this.typeMap.values();
    }

    public DataType getType(String name) {
        if (name == null) {
            return this.typeMap.get(EVENT);
        }
        DataType value = this.typeMap.get(name.toUpperCase());
        if (value != null) {
            return value;
        }
        EventType type = DataFactory.eINSTANCE.createEventType();
        type.setName(name);
        this.typeMap.put(name, type);
        return type;
    }
}

