/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public final class InterfaceListCopier {
    public static InterfaceList copy(InterfaceList src, boolean copyValues) {
        InterfaceList copy = LibraryElementFactory.eINSTANCE.createInterfaceList();
        InterfaceListCopier.copyVarList(copy.getInputVars(), src.getInputVars(), copyValues);
        InterfaceListCopier.copyVarList(copy.getOutputVars(), src.getOutputVars(), copyValues);
        InterfaceListCopier.copyEventList(copy.getEventInputs(), copy.getInputVars(), src.getEventInputs(), src.getInputVars());
        InterfaceListCopier.copyEventList(copy.getEventOutputs(), copy.getOutputVars(), src.getEventOutputs(), src.getOutputVars());
        InterfaceListCopier.copyAdapterList(copy.getPlugs(), src.getPlugs());
        InterfaceListCopier.copyAdapterList(copy.getSockets(), src.getSockets());
        InterfaceListCopier.copyErrorMarkerList(copy.getErrorMarker(), src.getErrorMarker(), copyValues);
        return copy;
    }

    private static void copyErrorMarkerList(EList<IInterfaceElement> copy, EList<IInterfaceElement> src, boolean copyValues) {
        src.forEach(c -> {
            boolean bl = copy.add((Object)InterfaceListCopier.copyMarker((ErrorMarkerInterface)c));
        });
    }

    private static ErrorMarkerInterface copyMarker(ErrorMarkerInterface src) {
        ErrorMarkerInterface copy = LibraryElementFactory.eINSTANCE.createErrorMarkerInterface();
        copy.setComment(src.getComment());
        copy.setName(src.getName());
        copy.setIsInput(src.isIsInput());
        copy.setType(src.getType());
        IInterfaceElement repairedEndpoint = copy.getRepairedEndpoint();
        if (repairedEndpoint != null) {
            copy.setRepairedEndpoint(repairedEndpoint);
        }
        return copy;
    }

    public static InterfaceList copy(InterfaceList src) {
        return InterfaceListCopier.copy(src, false);
    }

    public static void copyVarList(Collection<VarDeclaration> destVars, Collection<VarDeclaration> srcVars) {
        srcVars.forEach(variable -> {
            boolean bl = destVars.add(InterfaceListCopier.copyVar(variable, false));
        });
    }

    private static void copyVarList(EList<VarDeclaration> destVars, EList<VarDeclaration> srcVars, boolean copyValues) {
        srcVars.forEach(variable -> {
            boolean bl2 = destVars.add((Object)InterfaceListCopier.copyVar(variable, copyValues));
        });
    }

    public static VarDeclaration copyVar(VarDeclaration variable, boolean copyValues) {
        VarDeclaration copy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        copy.setArraySize(variable.getArraySize());
        copy.setComment(variable.getComment());
        copy.setIsInput(variable.isIsInput());
        copy.setName(variable.getName());
        copy.setType(variable.getType());
        copy.setTypeName(variable.getTypeName());
        Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
        if (copyValues && variable.getValue() != null) {
            varInitialization.setValue(variable.getValue().getValue());
        }
        copy.setValue(varInitialization);
        return copy;
    }

    private static void copyEventList(EList<Event> destEvents, EList<VarDeclaration> copyVars, EList<Event> srcEvents, EList<VarDeclaration> srcVars) {
        srcEvents.forEach(srcEvent -> {
            Event copy = InterfaceListCopier.copyEvent(srcEvent);
            InterfaceListCopier.copyWiths(copy, srcEvent, copyVars, srcVars);
            destEvents.add((Object)copy);
        });
    }

    public static Event copyEvent(Event srcEvent) {
        Event copy = LibraryElementFactory.eINSTANCE.createEvent();
        copy.setComment(srcEvent.getComment());
        copy.setIsInput(srcEvent.isIsInput());
        copy.setName(srcEvent.getName());
        copy.setType(srcEvent.getType());
        copy.setTypeName(srcEvent.getTypeName());
        return copy;
    }

    private static void copyWiths(Event copy, Event srcEvent, EList<VarDeclaration> copyVars, EList<VarDeclaration> srcVars) {
        for (With with : srcEvent.getWith()) {
            With withCopy = LibraryElementFactory.eINSTANCE.createWith();
            withCopy.setVariables((VarDeclaration)copyVars.get(srcVars.indexOf((Object)with.getVariables())));
            copy.getWith().add((Object)withCopy);
        }
    }

    private static void copyAdapterList(EList<AdapterDeclaration> destAdapters, EList<AdapterDeclaration> srcAdapters) {
        srcAdapters.forEach(adapter -> {
            AdapterDeclaration copy = InterfaceListCopier.copyAdapter(adapter);
            destAdapters.add((Object)copy);
        });
    }

    public static AdapterDeclaration copyAdapter(AdapterDeclaration adapter) {
        AdapterDeclaration copy = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        copy.setComment(adapter.getComment());
        copy.setIsInput(adapter.isIsInput());
        copy.setName(adapter.getName());
        copy.setPaletteEntry(adapter.getPaletteEntry());
        copy.setType(adapter.getType());
        copy.setTypeName(adapter.getTypeName());
        return copy;
    }

    private InterfaceListCopier() {
        throw new IllegalStateException("InterfaceListCopier is a utility class that can not be instantiated");
    }
}

