/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Point;

public final class FBNetworkHelper {
    public static final int Y_OFFSET_FROM_TOP_LEFT_CORNER = 80;
    public static final int X_OFFSET_FROM_TOP_LEFT_CORNER = 150;

    public static FBNetwork copyFBNetWork(FBNetwork srcNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        dstNetwork.getNetworkElements().addAll(EcoreUtil.copyAll(srcNetwork.getNetworkElements()));
        FBNetworkHelper.checkForAdapterFBs(dstNetwork, destInterface);
        FBNetworkHelper.createConnections(srcNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    public static FBNetwork createResourceFBNetwork(FBNetwork resourceTypeNetwork, InterfaceList destInterface) {
        FBNetwork dstNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        FBNetworkHelper.createResourceTypeFBs(resourceTypeNetwork.getNetworkElements(), dstNetwork);
        FBNetworkHelper.checkForAdapterFBs(dstNetwork, destInterface);
        FBNetworkHelper.createConnections(resourceTypeNetwork, dstNetwork, destInterface);
        return dstNetwork;
    }

    private static void createResourceTypeFBs(EList<FBNetworkElement> networkElements, FBNetwork dstNetwork) {
        networkElements.forEach(fb -> FBNetworkHelper.createResourceTypeFB(fb, dstNetwork));
    }

    private static void createResourceTypeFB(FBNetworkElement srcFb, FBNetwork dstNetwork) {
        ResourceTypeFB copy = LibraryElementFactory.eINSTANCE.createResourceTypeFB();
        dstNetwork.getNetworkElements().add((Object)copy);
        copy.setPaletteEntry(srcFb.getPaletteEntry());
        copy.setName(srcFb.getName());
        InterfaceList interfaceList = InterfaceListCopier.copy(srcFb.getInterface(), true);
        copy.setInterface(interfaceList);
        copy.setPosition((Position)EcoreUtil.copy((EObject)srcFb.getPosition()));
    }

    private static void checkForAdapterFBs(FBNetwork dstNetwork, InterfaceList destInterface) {
        for (FBNetworkElement elem : dstNetwork.getNetworkElements()) {
            AdapterDeclaration adapter;
            if (!(elem instanceof AdapterFB) || (adapter = destInterface.getAdapter(elem.getName())) == null) continue;
            ((AdapterFB)elem).setAdapterDecl(adapter);
        }
    }

    private static void createConnections(FBNetwork srcNetwork, FBNetwork dstNetwork, InterfaceList destInterface) {
        for (Connection connection : srcNetwork.getEventConnections()) {
            dstNetwork.getEventConnections().add((Object)((EventConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getDataConnections()) {
            dstNetwork.getDataConnections().add((Object)((DataConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
        for (Connection connection : srcNetwork.getAdapterConnections()) {
            dstNetwork.getAdapterConnections().add((Object)((AdapterConnection)FBNetworkHelper.createConnection(srcNetwork, destInterface, dstNetwork, connection)));
        }
    }

    private static Connection createConnection(FBNetwork srcNetwork, InterfaceList destInterface, FBNetwork dstNetwork, Connection connection) {
        Connection newConn = (Connection)EcoreUtil.copy((EObject)connection);
        newConn.setSource(FBNetworkHelper.getInterfaceElement(connection.getSource(), destInterface, dstNetwork, srcNetwork));
        newConn.setDestination(FBNetworkHelper.getInterfaceElement(connection.getDestination(), destInterface, dstNetwork, srcNetwork));
        return newConn;
    }

    private static IInterfaceElement getInterfaceElement(IInterfaceElement ie, InterfaceList typeInterface, FBNetwork dstNetwork, FBNetwork srcNetwork) {
        if (ie.getFBNetworkElement() == null) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        if (!srcNetwork.equals(ie.getFBNetworkElement().getFbNetwork())) {
            return typeInterface.getInterfaceElement(ie.getName());
        }
        FBNetworkElement element = dstNetwork.getElementNamed(ie.getFBNetworkElement().getName());
        if (element == null) {
            return null;
        }
        return element.getInterfaceElement(ie.getName());
    }

    public static Point getTopLeftCornerOfFBNetwork(List<?> selection) {
        Assert.isNotNull(selection);
        Point pt = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Object fb = null;
        for (Object sel : selection) {
            fb = (sel instanceof EditPart ? ((EditPart)sel).getModel() : sel);
            if (!(fb instanceof FBNetworkElement)) continue;
            Position pos = ((FBNetworkElement)fb).getPosition();
            pt.x = Math.min(pt.x, pos.getX());
            pt.y = Math.min(pt.y, pos.getY());
        }
        return pt;
    }

    public static void moveFBNetworkByOffset(Iterable<FBNetworkElement> fbNetwork, int xOffset, int yOffset) {
        for (FBNetworkElement el : fbNetwork) {
            Position pos = LibraryElementFactory.eINSTANCE.createPosition();
            pos.setX(el.getPosition().getX() + xOffset);
            pos.setY(el.getPosition().getY() + yOffset);
            el.setPosition(pos);
        }
    }

    public static Point removeXYOffsetForFBNetwork(List<FBNetworkElement> fbNetwork) {
        Point offset = FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbNetwork);
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, -offset.x + 150, -offset.y + 80);
        return offset;
    }

    public static void moveFBNetworkToDestination(List<FBNetworkElement> fbnetwork, Point destination) {
        Point current = FBNetworkHelper.getTopLeftCornerOfFBNetwork(fbnetwork);
        Point offset = new Point(destination.x - current.x, destination.y - current.y);
        FBNetworkHelper.moveFBNetworkByOffset(fbnetwork, offset);
    }

    public static void moveFBNetworkByOffset(List<FBNetworkElement> fbNetwork, Point offset) {
        FBNetworkHelper.moveFBNetworkByOffset(fbNetwork, offset.x, offset.y);
    }

    public static boolean targetSubappIsInSameFbNetwork(List<FBNetworkElement> elements, SubApp targetSubApp) {
        for (FBNetworkElement block : elements) {
            if (block.getFbNetwork().getNetworkElements().contains((Object)targetSubApp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTypeInsertionSave(FBType type, EObject element) {
        if (type == null || element == null) {
            return true;
        }
        FBType editorType = FBNetworkHelper.getRootType(element);
        if (editorType != null) {
            if (type.equals(editorType)) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.Error_SelfInsertion, editorType.getName()));
                return false;
            }
            if (FBNetworkHelper.containsType(editorType, FBNetworkHelper.getChildFBNElements(type))) {
                ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.Error_RecursiveType, type.getName(), editorType.getName()));
                return false;
            }
        }
        return true;
    }

    private static EList<? extends FBNetworkElement> getChildFBNElements(FBNetworkElement networkElem) {
        if (networkElem instanceof SubApp) {
            SubApp subapp = (SubApp)networkElem;
            if (subapp.isTyped()) {
                return subapp.getType().getFBNetwork().getNetworkElements();
            }
            return subapp.getSubAppNetwork().getNetworkElements();
        }
        FBType type = networkElem.getType();
        if (type != null) {
            return FBNetworkHelper.getChildFBNElements(type);
        }
        return new BasicEList();
    }

    private static EList<? extends FBNetworkElement> getChildFBNElements(FBType type) {
        if (type instanceof BaseFBType) {
            return ((BaseFBType)type).getInternalFbs();
        }
        if (type instanceof CompositeFBType) {
            return ((CompositeFBType)type).getFBNetwork().getNetworkElements();
        }
        return new BasicEList();
    }

    private static FBType getRootType(EObject element) {
        EObject root = EcoreUtil.getRootContainer((EObject)element);
        if (root instanceof FBType) {
            return (FBType)root;
        }
        return null;
    }

    private static boolean containsType(FBType editorType, EList<? extends FBNetworkElement> networkElementList) {
        for (FBNetworkElement elem : networkElementList) {
            if (editorType.equals(elem.getType())) {
                return true;
            }
            if (!FBNetworkHelper.containsType(editorType, FBNetworkHelper.getChildFBNElements(elem))) continue;
            return true;
        }
        return false;
    }

    private FBNetworkHelper() {
        throw new IllegalStateException("FBNetworkHelper is a utility class that can not be instantiated");
    }

    public static void loadSubappNetwork(FBNetworkElement network) {
        if (network instanceof SubApp) {
            SubApp subApp = (SubApp)network;
            subApp.loadSubAppNetwork();
            FBNetworkHelper.parseSubNetworks(subApp.getSubAppNetwork().getNetworkElements());
        } else if (network instanceof CFBInstance) {
            CFBInstance compositeFunctionBlock = (CFBInstance)network;
            compositeFunctionBlock.loadCFBNetwork();
            FBNetworkHelper.parseSubNetworks(compositeFunctionBlock.getCfbNetwork().getNetworkElements());
        }
    }

    private static void parseSubNetworks(List<FBNetworkElement> networkElements) {
        for (FBNetworkElement fbe : networkElements) {
            if (!FBNetworkHelper.hasNetwork(fbe)) continue;
            FBNetworkHelper.loadSubappNetwork(fbe);
        }
    }

    private static boolean hasNetwork(FBNetworkElement networkElement) {
        return networkElement instanceof SubApp || networkElement instanceof CFBInstance;
    }
}

