/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class StructTreeNode {
    protected VarDeclaration variable;
    protected StructTreeNode root;
    protected final String pinName;
    protected final List<StructTreeNode> children;
    protected StructTreeNode parent;
    protected TreeViewer viewer = null;

    protected StructTreeNode(VarDeclaration variable, StructTreeNode parent) {
        this.variable = variable;
        this.parent = parent;
        this.pinName = this.getFullPinName();
        this.children = new ArrayList<StructTreeNode>();
        this.root = parent.root;
    }

    protected StructTreeNode() {
        this.variable = null;
        this.parent = null;
        this.pinName = null;
        this.children = new ArrayList<StructTreeNode>();
        this.root = this;
    }

    public static void buildTree(StructManipulator struct, StructuredType structType, StructTreeNode parent) {
        for (VarDeclaration memberVariable : structType.getMemberVariables()) {
            StructTreeNode treeNode = parent.addChild(memberVariable);
            if (!(memberVariable.getType() instanceof StructuredType) || memberVariable.getType() == IecTypes.GenericTypes.ANY_STRUCT) continue;
            StructTreeNode.buildTree(struct, (StructuredType)memberVariable.getType(), treeNode);
        }
    }

    protected static String getVariableName(VarDeclaration variable) {
        return variable == null ? "" : variable.getName();
    }

    public Object[] getChildrenAsArray() {
        return this.children.toArray();
    }

    public VarDeclaration getVariable() {
        return this.variable;
    }

    public StructTreeNode getParent() {
        return this.parent;
    }

    public String getParentVarName() {
        return this.parent.pinName;
    }

    public String getPinName() {
        return this.pinName;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<StructTreeNode> getChildren() {
        return this.children;
    }

    private String getFullPinName() {
        if (this.parent == null || this.parent.pinName == null) {
            return StructTreeNode.getVariableName(this.variable);
        }
        return String.valueOf(this.parent.pinName) + "." + StructTreeNode.getVariableName(this.variable);
    }

    public void setViewer(TreeViewer viewer) {
        this.root.viewer = viewer;
    }

    public StructTreeNode addChild(VarDeclaration memberVariable) {
        StructTreeNode treeNode = new StructTreeNode(memberVariable, this);
        this.children.add(treeNode);
        return treeNode;
    }

    public static class StructTreeContentProvider
    implements ITreeContentProvider {
        private StructTreeNode root = null;

        public void setRoot(StructTreeNode root) {
            this.root = root;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StructManipulator) {
                return this.getMemberVariableNodes((StructManipulator)inputElement);
            }
            return new Object[0];
        }

        private Object[] getMemberVariableNodes(StructManipulator struct) {
            return this.root.getChildrenAsArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CheckableStructTreeNode) {
                return ((StructTreeNode)parentElement).getChildrenAsArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof CheckableStructTreeNode) {
                return ((StructTreeNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof StructTreeNode) {
                return ((StructTreeNode)element).hasChildren();
            }
            return false;
        }
    }

    public static class StructTreeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CheckableStructTreeNode) {
                VarDeclaration memVar = ((StructTreeNode)element).getVariable();
                switch (columnIndex) {
                    case 0: {
                        return memVar.getName();
                    }
                    case 1: {
                        return memVar.getTypeName();
                    }
                    case 2: {
                        return memVar.getComment();
                    }
                }
            }
            return element.toString();
        }
    }
}

