/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Multiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public final class StructManipulation {
    public static final String STRUCT_ATTRIBUTE = "StructuredType";
    public static final String CHILDREN_ATTRIBUTE = "VisibleChildren";
    public static final String DEMUX_NAME = "STRUCT_DEMUX";
    public static final String MUX_NAME = "STRUCT_MUX";

    public static void setStructTypeElementsAtInterface(StructManipulator muxer, StructuredType newStructType) {
        muxer.setStructType(newStructType);
        StructManipulation.configureAttributes(muxer);
        StructManipulation.setMemberVariablesAsPorts(muxer, newStructType);
    }

    private static void configureAttributes(StructManipulator muxer) {
        StructuredType struct = muxer.getStructType();
        if (struct == null) {
            muxer.deleteAttribute(STRUCT_ATTRIBUTE);
        } else {
            muxer.setAttribute(STRUCT_ATTRIBUTE, "STRING", struct.getName(), "");
        }
    }

    public static void setMemberVariablesAsPorts(StructManipulator muxer, StructuredType newStructType) {
        if (muxer instanceof Demultiplexer) {
            if (newStructType == null) {
                StructManipulation.setVariablesAsOutputs(muxer, Collections.emptyList(), null);
            } else if (muxer.getAttribute(CHILDREN_ATTRIBUTE) != null) {
                StructManipulation.setVariablesAsOutputs(muxer, StructManipulation.collectVisibleChildren(muxer, newStructType).getMemberVariables(), newStructType);
            } else {
                StructManipulation.setVariablesAsOutputs(muxer, newStructType.getMemberVariables(), newStructType);
            }
        }
        if (muxer instanceof Multiplexer) {
            StructManipulation.setVariablesAsInputs(muxer, newStructType);
        }
    }

    private static StructuredType collectVisibleChildren(StructManipulator muxer, StructuredType newStructType) {
        Attribute attr = muxer.getAttribute(CHILDREN_ATTRIBUTE);
        StructuredType configuredStruct = DataFactory.eINSTANCE.createStructuredType();
        configuredStruct.setName(newStructType.getName());
        configuredStruct.setComment(newStructType.getComment());
        List<String> visibleChildrenNames = Arrays.asList(attr.getValue().trim().split(","));
        Collection<VarDeclaration> visibleVars = StructManipulation.getVarDeclarations(muxer.getStructType(), visibleChildrenNames);
        configuredStruct.getMemberVariables().addAll(visibleVars);
        return configuredStruct;
    }

    private static void setVariablesAsInputs(StructManipulator muxer, StructuredType newStructType) {
        if (newStructType == null) {
            muxer.getInterface().getInputVars().clear();
        } else {
            Collection list = EcoreUtil.copyAll(newStructType.getMemberVariables());
            list.forEach(varDecl -> {
                if (muxer.getInterfaceElement(varDecl.getName()) == null) {
                    varDecl.setIsInput(true);
                    varDecl.setValue(LibraryElementFactory.eINSTANCE.createValue());
                }
            });
            Event ev = (Event)muxer.getInterface().getEventInputs().get(0);
            list.forEach(varDecl -> {
                With with = LibraryElementFactory.eINSTANCE.createWith();
                with.setVariables((VarDeclaration)varDecl);
                ev.getWith().add((Object)with);
            });
            muxer.getInterface().getInputVars().addAll(list);
            ((VarDeclaration)muxer.getInterface().getOutputVars().get(0)).setType(newStructType);
        }
    }

    private static void setVariablesAsOutputs(StructManipulator muxer, Collection<VarDeclaration> vars, StructuredType newStructType) {
        Collection list = EcoreUtil.copyAll(vars);
        list.forEach(varDecl -> {
            varDecl.setIsInput(false);
            varDecl.setValue(LibraryElementFactory.eINSTANCE.createValue());
        });
        EList<Event> outputEvents = muxer.getInterface().getEventOutputs();
        list.forEach(varDecl -> {
            With with = LibraryElementFactory.eINSTANCE.createWith();
            with.setVariables((VarDeclaration)varDecl);
            outputEvents.forEach(ev -> {
                boolean bl = ev.getWith().add((Object)with);
            });
        });
        muxer.getInterface().getOutputVars().clear();
        muxer.getInterface().getOutputVars().addAll(list);
        ((VarDeclaration)muxer.getInterface().getInputVars().get(0)).setType(newStructType);
    }

    private static Collection<VarDeclaration> getVarDeclarations(StructuredType structType, List<String> varDeclNames) {
        ArrayList<VarDeclaration> vars = new ArrayList<VarDeclaration>();
        varDeclNames.forEach(name -> {
            VarDeclaration varDecl = (VarDeclaration)EcoreUtil.copy((EObject)StructManipulation.findVarDeclarationInStruct(structType, name));
            if (varDecl != null) {
                varDecl.setName((String)name);
                vars.add(varDecl);
            }
        });
        return vars;
    }

    private static VarDeclaration findVarDeclarationInStruct(StructuredType struct, String name) {
        String[] subnames = name.split("\\.");
        EList<VarDeclaration> members = struct.getMemberVariables();
        IInterfaceElement found = null;
        String[] stringArray = subnames;
        int n = subnames.length;
        int n2 = 0;
        while (n2 < n) {
            String subname = stringArray[n2];
            Object[] findings = members.stream().filter(memVar -> memVar.getName().equals(subname)).toArray();
            if (findings.length > 0) {
                found = (VarDeclaration)findings[0];
            }
            if (found != null && found.getType() instanceof StructuredType) {
                members = ((StructuredType)found.getType()).getMemberVariables();
            }
            ++n2;
        }
        return found;
    }

    private StructManipulation() {
        throw new UnsupportedOperationException();
    }
}

