/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.text.MessageFormat;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.fordiac.ide.model.FordiacKeywords;
import org.eclipse.fordiac.ide.model.IdentifierVerifyer;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;

public final class NameRepository {
    private NameRepository() {
    }

    public static String createUniqueTypeName(LibraryElement type) {
        TypeLibrary typeLibrary = type.getTypeLibrary();
        Palette blockTypeLib = typeLibrary.getBlockTypeLib();
        String typeName = type.getName();
        if (type instanceof DataType) {
            DataTypeLibrary dataTypeLibrary = typeLibrary.getDataTypeLibrary();
            while (dataTypeLibrary.getTypeIfExists(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof FBType) {
            while (blockTypeLib.getFBTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof SubAppType) {
            while (blockTypeLib.getSubAppTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        if (type instanceof AdapterType) {
            while (blockTypeLib.getAdapterTypeEntry(typeName) != null) {
                typeName = NameRepository.createUniqueName(type.getName(), typeName);
            }
            return typeName;
        }
        return null;
    }

    public static String createUniqueName(INamedElement element, String nameProposal) {
        Assert.isTrue((boolean)IdentifierVerifyer.isValidIdentifier(nameProposal), (String)"The given name proposal is not a valid identifier!");
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        String retVal = nameProposal;
        if (element instanceof IInterfaceElement) {
            retVal = NameRepository.checkReservedKeyWords(nameProposal);
        }
        return NameRepository.getUniqueName(NameRepository.getRefNames(element), retVal);
    }

    public static boolean isValidName(INamedElement element, String nameProposal) {
        Assert.isNotNull((Object)element.eContainer(), (String)"For a correct operation createuniqueName expects that the model element is already added in its containing model!");
        if (!IdentifierVerifyer.isValidIdentifier(nameProposal)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameNotAValidIdentifier, nameProposal));
            return false;
        }
        if (element instanceof IInterfaceElement && FordiacKeywords.RESERVED_KEYWORDS.contains(nameProposal)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameReservedKeyWord, nameProposal));
            return false;
        }
        if (NameRepository.getRefNames(element).contains(nameProposal)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.NameRepository_NameAlreadyExists, nameProposal));
            return false;
        }
        return true;
    }

    private static Set<String> getRefNames(INamedElement refElement) {
        Object elementsList = null;
        if (refElement instanceof Algorithm) {
            elementsList = ((BasicFBType)((Algorithm)refElement).eContainer()).getAlgorithm();
        } else if (refElement instanceof Application) {
            elementsList = ((Application)refElement).getAutomationSystem().getApplication();
        } else if (refElement instanceof Device) {
            elementsList = ((Device)refElement).getSystemConfiguration().getDevices();
        } else if (refElement instanceof FBNetworkElement) {
            elementsList = refElement.eContainer() instanceof BaseFBType ? ((BaseFBType)refElement.eContainer()).getInternalFbs() : ((FBNetworkElement)refElement).getFbNetwork().getNetworkElements();
        } else if (refElement instanceof Resource) {
            elementsList = ((Resource)refElement).getDevice().getResource();
        } else if (refElement instanceof Segment) {
            elementsList = ((SystemConfiguration)((Segment)refElement).eContainer()).getSegments();
        } else if (refElement instanceof ECState) {
            elementsList = ((ECC)((ECState)refElement).eContainer()).getECState();
        } else if (refElement instanceof IInterfaceElement) {
            if (((IInterfaceElement)refElement).eContainer() instanceof StructuredType) {
                elementsList = ((StructuredType)((IInterfaceElement)refElement).eContainer()).getMemberVariables();
            } else {
                BasicEList elements = new BasicEList();
                InterfaceList interfaceList = null;
                interfaceList = ((IInterfaceElement)refElement).eContainer() instanceof InterfaceList ? (InterfaceList)((IInterfaceElement)refElement).eContainer() : ((BaseFBType)((IInterfaceElement)refElement).eContainer()).getInterfaceList();
                elements.addAll(interfaceList.getAllInterfaceElements());
                if (interfaceList.eContainer() instanceof BaseFBType) {
                    elements.addAll(((BaseFBType)interfaceList.eContainer()).getInternalVars());
                }
                elementsList = elements;
            }
        } else if (refElement instanceof ServiceSequence) {
            ServiceSequence seq = (ServiceSequence)refElement;
            elementsList = seq.getService().getServiceSequence();
        } else {
            throw new IllegalArgumentException("Reference list for given class not available: " + refElement.getClass().toString());
        }
        return elementsList.stream().filter(element -> element != refElement).map(INamedElement::getName).collect(Collectors.toSet());
    }

    private static String getUniqueName(Set<String> existingNameList, String nameProposal) {
        String temp = nameProposal;
        while (existingNameList.contains(temp)) {
            temp = NameRepository.createUniqueName(nameProposal, temp);
        }
        return temp;
    }

    static String createUniqueName(String nameProposal, String temp) {
        String digits = NameRepository.extractDigitsFromEnd(temp);
        if (!"".equals(digits)) {
            try {
                long newNumber = (long)Integer.parseInt(digits) + 1L;
                if (newNumber > Integer.MAX_VALUE) {
                    return NameRepository.createFallbackProposal(nameProposal);
                }
                return String.valueOf(temp.substring(0, temp.length() - digits.length())) + NameRepository.zeroPrefixedNumber(newNumber, digits.length());
            }
            catch (NumberFormatException numberFormatException) {
                return NameRepository.createFallbackProposal(nameProposal);
            }
        }
        return NameRepository.createFallbackProposal(nameProposal);
    }

    private static String zeroPrefixedNumber(long number, int digits) {
        String zeroPrefixedDecimal = "%0" + digits + "d";
        return String.format(zeroPrefixedDecimal, number);
    }

    private static String createFallbackProposal(String nameProposal) {
        return String.valueOf(nameProposal) + "_1";
    }

    private static String extractDigitsFromEnd(String data) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        int i = data.length() - 1;
        while (i > 0 && c <= 10) {
            if (data.charAt(i) < '0' || data.charAt(i) > '9') break;
            sb.insert(0, data.charAt(i));
            --i;
            ++c;
        }
        if (c > 10) {
            return "";
        }
        return sb.toString();
    }

    private static String checkReservedKeyWords(String name) {
        if (FordiacKeywords.RESERVED_KEYWORDS.contains(name.toUpperCase())) {
            return String.valueOf(name) + "1";
        }
        return name;
    }
}

