/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.TreeSet;

public final class FordiacKeywords {
    public static final Set<String> RESERVED_KEYWORDS = FordiacKeywords.getKeywords();
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_ADAPTER = "ANY_ADAPTER";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DATE = "ANY_DATE";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_STRING = "ANY_STRING";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_BIT = "ANY_BIT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_REAL = "ANY_REAL";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_INT = "ANY_INT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_NUM = "ANY_NUM";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_MAGNITUDE = "ANY_MAGNITUDE";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_ELEMENTARY = "ANY_ELEMENTARY";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY = "ANY";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_STRUCT = "ANY_STRUCT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DERIVED = "ANY_DERIVED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_SIGNED = "ANY_SIGNED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_UNSIGNED = "ANY_UNSIGNED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DURATION = "ANY_DURATION";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_CHAR = "ANY_CHAR";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_CHARS = "ANY_CHARS";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DINT = "DINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String INT = "INT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String SINT = "SINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LINT = "LINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String UINT = "UINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String USINT = "USINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String UDINT = "UDINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String ULINT = "ULINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String REAL = "REAL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LREAL = "LREAL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String STRING = "STRING";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WSTRING = "WSTRING";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String CHAR = "CHAR";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WCHAR = "WCHAR";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String ANY_TIME = "ANY_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TIME = "TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTIME = "LTIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TIME_OF_DAY = "TIME_OF_DAY";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTIME_OF_DAY = "LTIME_OF_DAY";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TOD = "TOD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTOD = "LTOD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDT = "LDT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DATE = "DATE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDATE = "LDATE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DATE_AND_TIME = "DATE_AND_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DT = "DT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDATE_AND_TIME = "LDATE_AND_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String BOOL = "BOOL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String BYTE = "BYTE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WORD = "WORD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DWORD = "DWORD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LWORD = "LWORD";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String DAY = "D";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String HOUR = "H";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MINUTE = "M";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String SECOND = "S";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MILLISECOND = "MS";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MICROSECOND = "US";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String NANOSECOND = "NS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXPONENT = "E";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR = "VAR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_VAR = "END_VAR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONSTANT = "CONSTANT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SUPER = "SUPER";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String RETURN = "RETURN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String IF = "IF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String THEN = "THEN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_IF = "END_IF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ELSIF = "ELSIF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ELSE = "ELSE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CASE = "CASE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OF = "OF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_CASE = "END_CASE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXIT = "EXIT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONTINUE = "CONTINUE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FOR = "FOR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TO = "TO";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String BY = "BY";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String DO = "DO";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_FOR = "END_FOR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String WHILE = "WHILE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_WHILE = "END_WHILE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String REPEAT = "REPEAT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String UNTIL = "UNTIL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_REPEAT = "END_REPEAT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OR = "OR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String XOR = "XOR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String AND = "AND";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MOD = "MOD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NOT = "NOT";
    @ModelString
    public static final String VARIABLE_INTERNAL = "InternalVar1";
    @ModelString
    public static final String EVENT_INPUT = "EI1";
    @ModelString
    public static final String EVENT_OUTPUT = "EO1";
    @ModelString
    public static final String DATA_INPUT = "DI1";
    @ModelString
    public static final String DATA_OUTPUT = "DO1";
    @ModelString
    public static final String ADAPTER_SOCKET = "SOCKET1";
    @ModelString
    public static final String ADAPTER_PLUG = "PLUG1";
    @ModelString
    public static final String INTERFACE_Y_POSITION = "YPOSITION";

    private FordiacKeywords() {
        throw new UnsupportedOperationException();
    }

    private static Set<String> getKeywords() {
        Class<FordiacKeywords> clazz = FordiacKeywords.class;
        TreeSet<String> keywordSet = new TreeSet<String>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getType().equals(String.class) && field.isAnnotationPresent(Keyword.class)) {
                try {
                    keywordSet.add((String)field.get(null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        return Set.copyOf(keywordSet);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface Keyword {
        public KeywordTypes value();
    }

    public static enum KeywordTypes {
        DATATYPE,
        DATATYPE_CLASS,
        TIME_UNIT,
        STRUCTURED_TEXT;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface ModelString {
    }
}

